% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idd.R
\name{get_idd_relation}
\alias{get_idd_relation}
\title{Get field relation data}
\usage{
get_idd_relation(
  idd_env,
  class_id = NULL,
  field_id = NULL,
  direction = c("ref_to", "ref_by"),
  depth = 0L,
  name = FALSE,
  class = NULL,
  group = NULL,
  keep_all = FALSE,
  class_ref = c("both", "none", "all"),
  match_all = FALSE
)
}
\arguments{
\item{idd_env}{An environment or list contains IDD tables including class,
field, and reference.}

\item{class_id}{An integer vector of valid class indexes. Should be \code{NULL} if
\code{field_id} is given.}

\item{field_id}{An integer vector of valid field id. Should be \code{NULL} if
\code{class_id} is given.}

\item{direction}{The relation direction to extract. Should be one of
\code{"ref_to"} or \code{"ref_by"}.}

\item{depth}{If > 0, the relation is searched recursively. If \code{NULL},
all possible recursive relations are returned. Default: \code{0}.}

\item{name}{If \code{TRUE}, additional formatting columns are added and an
\code{IddRelation} object is returned. Default: \code{FALSE}.}

\item{class, group}{A character vector of group names used for searching
relations. Default: \code{NULL}.}

\item{class_ref}{Specify how to handle class-name-references. There are 3
options in total, i.e. \code{"none"}, \code{"both"} and \code{"all"}, with \code{"both"}
being the default.
* \code{"none"}: just ignore class-name-references.
* \code{"both"}: only include class-name-references if this object
also reference field values of the same one. This is the default
option.
* \code{"all"}: include all class-name-references. This is the most aggressive
option.}

\item{match_all}{If \code{TRUE}, relation search will continue even though one
relation has been found. If \code{FALSE}, searching is stopped whenever one
relation is found in specified classes/groups. Default: \code{FALSE}.}
}
\value{
A data.table.
}
\description{
Get field relation data
}
\keyword{internal}
