% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate_objects}
\alias{validate_objects}
\title{Validate input IDF data in terms of various aspects}
\usage{
validate_objects(
  idd_env,
  idf_env,
  dt_object = NULL,
  dt_value = NULL,
  required_object = FALSE,
  unique_object = FALSE,
  unique_name = FALSE,
  extensible = FALSE,
  required_field = FALSE,
  auto_field = FALSE,
  type = FALSE,
  choice = FALSE,
  range = FALSE,
  reference = FALSE
)
}
\arguments{
\item{idd_env}{An environment that contains IDD data}

\item{idf_env}{An environment that contains IDF data}

\item{dt_object}{A data.table that contains object data to validate. If
\code{NULL}, the object data from \code{idf_env} will be used, which means to
validate the whole IDF.}

\item{dt_value}{A data.table that contains value data to validate. If
\code{NULL}, the value data from \code{idf_env} will be used, which means to
validate the whole IDF.}

\item{required_object}{Whether to check if required objects are missing. This
will only be applied when checking the whole IDF.}

\item{unique_object}{Whether to check if there are multiple instances of
unique object.}

\item{unique_name}{Whether to check if there are objects having the same name
in same class.}

\item{extensible}{Whether to check if there are incomplete extensible.}

\item{required_field}{Whether to check if there are missing value for
required fields.}

\item{auto_field}{Whether to check if there are non-autosizable or
non-autocalculatable fields that are assigned "autosize" or
"autocalculate".}

\item{type}{Whether to check if there are input values whose type are not
consistent with definitions in IDD.}

\item{choice}{Whether to check if there are invalid choice values.}

\item{range}{Whether to check if there are numeric values that are out of
ranges specified in IDD.}

\item{reference}{Whether to check if there are values that have invalid
references.}
}
\value{
An IdfValidity object.
}
\description{
Validate input IDF data in terms of various aspects
}
\keyword{internal}
