% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eplusr.R
\docType{package}
\name{eplusr-package}
\alias{eplusr}
\alias{eplusr-package}
\title{eplusr: A Toolkit for Using EnergyPlus in R}
\description{
A rich toolkit of using the whole building simulation program
    'EnergyPlus'(<https://energyplus.net>), which enables programmatic
    navigation, modification of 'EnergyPlus' models and makes it less painful to
    do parametric simulations and analysis.
}
\details{
eplusr provides a rich toolkit of using EnergyPlus directly in
R, which enables programmatic navigation, modification of EnergyPlus models
and makes it less painful to do parametric simulations and analysis.

With eplusr, you can do:
\itemize{
\item Read, parse and modify EnergyPlus Weather File (EPW).
\item Read and parse EnergyPlus IDF files.
\item Query on models, including classes, objects and fields
\item Directly add, modify, duplicate, and delete objects of IDF in R.
\item Automatically change referred fields when modifying objects.
\item Check any possible errors whenever modifications are made.
\item Save the changed models into standard formats in the same way as IDFEditor
distributed along with EnergyPlus.
\item Run your models directly and collect the simulation output of EnergyPlus
in R.
\item Run parametric analysis in parallel and collect results in one go.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://hongyuanjia.github.io/eplusr}
  \item \url{https://github.com/hongyuanjia/eplusr}
  \item Report bugs at \url{https://github.com/hongyuanjia/eplusr/issues}
}

}
\author{
Hongyuan Jia
}
