% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virus.R
\name{virus}
\alias{virus}
\alias{epiworld_virus}
\alias{set_name_virus}
\alias{get_name_virus}
\alias{add_virus}
\alias{virus_set_state}
\alias{rm_virus}
\alias{virus_fun_logit}
\alias{set_prob_infecting}
\alias{set_prob_infecting_ptr}
\alias{set_prob_infecting_fun}
\alias{set_prob_recovery}
\alias{set_prob_recovery_ptr}
\alias{set_prob_recovery_fun}
\alias{set_prob_death}
\alias{set_prob_death_ptr}
\alias{set_prob_death_fun}
\alias{set_incubation}
\alias{set_incubation_ptr}
\alias{set_incubation_fun}
\alias{set_distribution_virus}
\alias{distribute_virus_randomly}
\alias{distribute_virus_set}
\title{Virus design}
\usage{
virus(
  name,
  prevalence,
  as_proportion,
  prob_infecting,
  recovery_rate = 0.5,
  prob_death = 0,
  post_immunity = -1,
  incubation = 7
)

set_name_virus(virus, name)

get_name_virus(virus)

add_virus(model, virus, proportion)

virus_set_state(virus, init, end, removed)

rm_virus(model, virus_pos)

virus_fun_logit(vars, coefs, model)

set_prob_infecting(virus, prob)

set_prob_infecting_ptr(virus, model, param)

set_prob_infecting_fun(virus, model, vfun)

set_prob_recovery(virus, prob)

set_prob_recovery_ptr(virus, model, param)

set_prob_recovery_fun(virus, model, vfun)

set_prob_death(virus, prob)

set_prob_death_ptr(virus, model, param)

set_prob_death_fun(virus, model, vfun)

set_incubation(virus, incubation)

set_incubation_ptr(virus, model, param)

set_incubation_fun(virus, model, vfun)

set_distribution_virus(virus, distfun)

distribute_virus_randomly(prevalence, as_proportion)

distribute_virus_set(agents_ids)
}
\arguments{
\item{name}{of the virus}

\item{prevalence}{Numeric scalar. Prevalence of the virus.}

\item{as_proportion}{Logical scalar. If \code{TRUE}, the prevalence is set as a
proportion of the total number of agents in the model.}

\item{prob_infecting}{Numeric scalar. Probability of infection (transmission).}

\item{recovery_rate}{Numeric scalar. Probability of recovery.}

\item{prob_death}{Numeric scalar. Probability of death.}

\item{post_immunity}{Numeric scalar. Post immunity (prob of re-infection).}

\item{incubation}{Numeric scalar. Incubation period (in days) of the virus.}

\item{virus}{An object of class \code{epiworld_virus}}

\item{model}{An object of class \code{epiworld_model}.}

\item{proportion}{Deprecated.}

\item{init, end, removed}{states after acquiring a virus, removing a virus,
and removing the agent as a result of the virus, respectively.}

\item{virus_pos}{Positive integer. Index of the virus's position in the model.}

\item{vars}{Integer vector. Indices (starting from 0) of the positions of the
variables used to compute the logit probability.}

\item{coefs}{Numeric vector. Of the same length of \code{vars}, is a vector of
coefficients associated to the logit probability.}

\item{prob}{Numeric scalar. A probability (between zero and one).}

\item{param}{Character scalar. Name of the parameter featured in \code{model} that
will be added to the virus (see details).}

\item{vfun}{An object of class \code{epiworld_virus_fun}.}

\item{distfun}{An object of class \code{epiworld_distribution_virus}.}

\item{agents_ids}{Integer vector. Indices of the agents that will receive the
virus.}
}
\value{
\itemize{
\item The \code{set_name_virus} function does not return a value, but merely assigns
a name to the virus of choice.
}

\itemize{
\item The \code{get_name_virus} function returns the name of the virus of class
\link{epiworld_virus}.
}

\itemize{
\item The \code{add_virus} function does not return a value, instead it adds the
virus of choice to the model object of class \link{epiworld_model}.
}

\itemize{
\item The \code{virus_set_state} function does not return a value but assigns
epidemiological properties to the specified virus of class \link{epiworld_virus}.
}

\itemize{
\item The \code{rm_virus} function does not return a value, but instead removes
a specified virus from the model of class \link{epiworld_model}.
}

\itemize{
\item The \code{set_prob_infecting} function does not return a value, but instead
assigns a probability to infection for the specified virus of class
\link{epiworld_virus}.
}

\itemize{
\item The \code{set_prob_recovery} function does not return a value, but instead
assigns a probability to recovery for the specified virus of class
\link{epiworld_virus}.
}

\itemize{
\item The \code{set_prob_death} function does not return a value, but instead
assigns a probability to death for the specified virus of class
\link{epiworld_virus}.
}

\itemize{
\item The \code{set_incubation} function does not return a value, but instead
assigns an incubation period to the specified virus of class \link{epiworld_virus}.
}

\itemize{
\item The \code{distribute_virus_randomly} function returns a function that can be
used to distribute the virus in the model.
}
}
\description{
Viruses can be considered to be anything that can be transmitted (e.g.,
diseases, as well as ideas.) Most models in epiworldR can feature multiple
viruses.
}
\details{
The \code{\link[=virus]{virus()}} function can be used to initialize a virus. Virus features can
then be modified using the functions \verb{set_prob_*}.

The function \code{\link[=virus_fun_logit]{virus_fun_logit()}} creates a "virus function" that can be
evaluated for transmission, recovery, and death. As the name sugests, it
computes those probabilities using a logit function (see examples).

The name of the \code{epiworld_virus} object can be manipulated with the functions
\code{\link[=set_name_virus]{set_name_virus()}} and \code{\link[=get_name_virus]{get_name_virus()}}.

In the case of \code{set_prob_infecting_ptr}, \code{set_prob_recovery_ptr}, and
\code{set_prob_death_ptr}, the corresponding parameters is passed as a pointer to
the virus. The implication of using pointers is that the values will be
read directly from the \code{model} object, so changes will be reflected.

The \code{distribute_virus_randomly} function is a factory function
used to randomly distribute the virus in the model. The prevalence can be set
as a proportion or as a number of agents. The resulting function can then be
passed to \code{set_distribution_virus}.
}
\examples{
mseirconn <- ModelSEIRCONN(
  name                = "COVID-19",
  prevalence          = 0.01,
  n                   = 10000,
  contact_rate        = 4,
  incubation_days     = 7,
  transmission_rate   = 0.5,
  recovery_rate       = 0.99
)

delta <- virus(
  "Delta Variant", 0, .5, .2, .01, prevalence = 0.3, as_proportion = TRUE
)

# Adding virus and setting/getting virus name
add_virus(mseirconn, delta)
set_name_virus(delta, "COVID-19 Strain")
get_name_virus(delta)

run(mseirconn, ndays = 100, seed = 992)
mseirconn

rm_virus(mseirconn, 0) # Removing the first virus from the model object
set_distribution_virus(delta, distribute_virus_randomly(100, as_proportion = FALSE))
add_virus(mseirconn, delta)

# Setting parameters for the delta virus manually
set_prob_infecting(delta, 0.5)
set_prob_recovery(delta, 0.9)
set_prob_death(delta, 0.01)
run(mseirconn, ndays = 100, seed = 992) # Run the model to observe changes

# If the states were (for example):
# 1: Infected
# 2: Recovered
# 3: Dead
delta2 <- virus(
  "Delta Variant 2", 0, .5, .2, .01, prevalence = 0, as_proportion = TRUE
)
virus_set_state(delta2, 1, 2, 3)
# Using the logit function --------------
sir <- ModelSIR(
  name = "COVID-19", prevalence = 0.01,
  transmission_rate = 0.9, recovery = 0.1
)

# Adding a small world population
agents_smallworld(
  sir,
  n = 10000,
  k = 5,
  d = FALSE,
  p = .01
)

run(sir, ndays = 50, seed = 11)
plot(sir)

# And adding features
dat <- cbind(
  female = sample.int(2, 10000, replace = TRUE) - 1,
  x      = rnorm(10000)
)

set_agents_data(sir, dat)

# Creating the logit function
vfun <- virus_fun_logit(
  vars  = c(0L, 1L),
  coefs = c(-1, 1),
  model = sir
)

# The infection prob is lower
hist(plogis(dat \%*\% rbind(-1, 1)))

vfun # printing

set_prob_infecting_fun(
  virus = get_virus(sir, 0),
  model = sir,
  vfun  = vfun
)

run(sir, ndays = 50, seed = 11)
plot(sir)

}
