% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alert.R
\name{ears_t_reweighted}
\alias{ears_t_reweighted}
\title{algorithm for outbreak detection, extends the EARS algorithm}
\usage{
ears_t_reweighted(
  ts,
  alpha = 0.025,
  alpha_outlier = 0.05,
  k_decay = 4,
  no_historic = 7L,
  same_weekday_baseline = FALSE
)
}
\arguments{
\item{ts}{A numeric vector containing the counts of the univariate
time series to monitor. The last time point in ts is
investigated}

\item{alpha}{The alpha is used to compute the upper limit of the prediction interval:
(1-alpha) * 100\%, default: 0.025}

\item{alpha_outlier}{Residuals beyond 1-alpha_outlier quantile of the 
the t(n-k-1) distribution are downweighted, default: 0.05}

\item{k_decay}{Power k in the expression (r_star/r_threshold)^k determining the weight, default: 4}

\item{no_historic}{Number of previous values i.e -1, -2, ..., no_historic
to include when computing baseline parameters, default: 7}

\item{same_weekday_baseline}{whether to calculate baseline using same weekdays or any day, default: FALSE}
}
\value{
A dataframe containing the monitored time point,
        the upper limit and whether a signal is detected or not.
}
\description{
The simple 7 day running mean version of the Early Aberration Reporting System (EARS) 
algorithm is extended as follows:
\itemize{
  \item{proper computation of the prediction interval}
  \item{downweighting of previous signals, similar to the approach by Farrington (1996)}
}
}
\details{
for algorithm details see package vignette.
}
\examples{
if(FALSE){
   library(epitweetr)
   #Running the modifies version of the ears algorithm for a particular data series
    ts <- c(150, 130, 122, 160, 155, 128, 144, 125, 300, 319, 289, 277, 500)
    show(ears_t_reweighted(ts))
}
}
\author{
Michael Hoehle <https://www.math.su.se/~hoehle>
}
