% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiparameter.R
\name{is_truncated}
\alias{is_truncated}
\title{Check if distribution in \verb{<epiparameter>} is truncated}
\usage{
is_truncated(x)
}
\arguments{
\item{x}{An \verb{<epiparameter>} object.}
}
\value{
A boolean \code{logical}.
}
\description{
Check if distribution in \verb{<epiparameter>} is truncated
}
\details{
The \verb{<epiparameter>} class can hold probability distribution objects
from the \code{{distributional}} package or the \code{{distcrete}} package,
however, only distribution objects from \code{{distributional}} can be truncated.
If a \verb{<epiparameter>} object has a \verb{<distcrete>} object \code{is_truncated} will
return \code{FALSE} by default.
}
\examples{
ep <- epiparameter(
  disease = "ebola",
  epi_name = "incubation_period",
  prob_distribution = create_prob_distribution(
    prob_distribution = "lnorm",
    prob_distribution_params = c(meanlog = 1, sdlog = 1)
  )
)
is_truncated(ep)

ep <- epiparameter(
  disease = "ebola",
  epi_name = "incubation_period",
  prob_distribution = create_prob_distribution(
    prob_distribution = "lnorm",
    prob_distribution_params = c(meanlog = 1, sdlog = 1),
    truncation = 10
  )
)
is_truncated(ep)
}
