% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiobs.R
\name{epiobs}
\alias{epiobs}
\title{Define Observational Models}
\usage{
epiobs(
  formula,
  i2o,
  family = "neg_binom",
  link = "logit",
  center = FALSE,
  prior = rstanarm::normal(scale = 0.2),
  prior_intercept = rstanarm::normal(scale = 0.2),
  prior_aux = rstanarm::normal(location = 10, scale = 5),
  ...
)
}
\arguments{
\item{formula}{An object of class \code{formula} which determines the linear predictor for the ascertainment rate.
The left hand side must define the response that is being modeled (i.e. the actual observations, not the latent ascertainment rates) in a given country on a given date.}

\item{i2o}{A numeric (simplex) vector defining the probability mass function
of the time distribution from infection to observation (i.e. a single death or
hospitalization etc.). The \eqn{n}th element represents the probability that the
individual was infected exactly \eqn{n} days prior to this.}

\item{family}{A string representing the family of the sampling distribution.
Can be "poisson", "neg_binom", "quasi_poisson", "normal" or "log_normal".}

\item{link}{A string representing the link function used to transform the linear predictor. Can be one of \code{"logit"}, \code{"probit"}, \code{"cauchit"}, \code{"cloglog"}, \code{"identity"}.
Defaults to \code{"logit"}.}

\item{center}{If \code{TRUE} then the covariates are centered to
have mean zero. All of the priors are then interpreted as
priors on the centered covariates. Defaults to \code{FALSE}.}

\item{prior}{Same as in \code{\link[rstanarm]{stan_glm}}. \strong{Note:}
If \code{autoscale=TRUE} in the call to the prior distribution
then automatic rescaling of the prior may take place.}

\item{prior_intercept}{Same as in \code{\link[rstanarm]{stan_glm}}. Prior
for the regression intercept, if one has been specified.}

\item{prior_aux}{The prior distribution for the auxiliary parameter, if it exists.
Only used if family is "neg_binom" (reciprocal dispersion), "quasi_poisson" (dispersion), "normal" (standard deviation) or "log_normal" (sigma parameter). Can be a call to \code{\link[rstanarm]{exponential}},
\code{\link[rstanarm]{normal}}, \code{\link[rstanarm]{student_t}} or \code{\link[rstanarm]{cauchy}}. These result in half-normal, half-t and half-cauchy priors.}

\item{...}{Additional arguments for \code{\link[stats]{model.frame}}}
}
\value{
An object of class \code{epiobs}.
}
\description{
\code{\link{epiobs}} defines a model for an observation vector. These observations
are taken to be a function of the latent infections in the population.
Examples include daily death or hospitalization rates. For more details on
the model assumptions please refer to the \href{https://imperialcollegelondon.github.io/epidemia/articles/model-description.html}{model description}
vignette.
}
\details{
Each observational model is given by a call to \code{\link{epiobs}}.
In particular, this must define the model for ascertainment rates and the time distribution from infection to observation.
\code{\link{epiobs}} has a \code{formula} argument. The left hand side must define the observation vector  to be modeled, while the right hand side defines a linear predictor for the ascertainment rate.
The argument \code{i2o} plays a similar role to the \code{gen} argument in \code{epiinf}, however it instead defines the probability mass function for the time between infection and observation.
}
\examples{
data(EuropeCovid)
# constant ascertainment rate (intercept model)
# link ensures ascertainment is between 0 and 2\%
deaths <- epiobs(
 deaths ~ 1,
 i2o = EuropeCovid$inf2death,
 link = scaled_logit(0.02)
)
}
