% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{subsample}
\alias{subsample}
\title{Creates multiple subsamples without replacement}
\usage{
subsample(n, size = n\%/\%2, n_subsample)
}
\arguments{
\item{n}{original sample size}

\item{size}{subsample size}

\item{n_subsample}{total number of subsamples}
}
\value{
a matrix of indices with \code{size} rows
and \code{n_subsample} columns.
}
\description{
The subsampling is iteratively performed in order to generate
multiple subsamples of a predetermined size.
}
\examples{
n <- 50 # Total number of samples
n_subsample <- 10 # Number of subsamples

sub_matrix <- subsample(n = n, n_subsample = n_subsample)
}
