% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{modified_outcome}
\alias{modified_outcome}
\title{Implements the modified outcome approach}
\usage{
modified_outcome(A, X, Y, propensity, parallel = FALSE, ...)
}
\arguments{
\item{A}{target variant}

\item{X}{rest of the genotype}

\item{Y}{phenotype}

\item{propensity}{propensity scores vector/matrix. If given as a matrix,
the first column is \eqn{\pi(A = 0| X)}{P(A = 0|X)} while the second
is \eqn{\pi(A = 1| X)}{P(A = 1|X)}}

\item{parallel}{whether to perform support estimation in a
parallelized fashion with the \code{\link{stabilityBIG}} function}

\item{...}{additional arguments to be passed to \code{stabilityGLM} or
\code{stabilityBIG}}
}
\value{
a vector containing the area under the stability selection path for
  each variable in \code{X}
}
\description{
In the modified outcome approach, we estimate the risk difference
\eqn{E\left[Y| A=1,X\right]-E\left[Y| A=0,X\right]}{E[Y|A=1,X]-E[Y|A=0,X]}.
The risk difference measures the synergy between \code{A} and the set of
covariates in \code{X}. For genome-wide association studies, it can be
interpreted as a pure epistatic term. However, for a single sample, we only
observe one of the two possibilities A=1 or A=0, making the direct
estimate of the risk difference impossible. Through propensity scores,
modified outcome was proposed as a solution to this problem. The risk
difference is recovered by constructing a modified outcome that combines
A, Y and the propensity score \eqn{\pi(A| X)}{P(A|X)}:
\eqn{Y \times \left[\frac{A}{\pi(A=1| X)} - \frac{1-A}{1-\pi(A=1| X)} \right]}{Y x [A/P(A=1|X) -(1-A)/P(A=0|X)]}.
The use of \code{\link{stabilityGLM}} or \code{\link{stabilityBIG}} for
the modified outcome regression allows us to recover the
interacting components within \code{X}.
}
\examples{
n <- 30
p <- 10
X <- matrix((runif(n * p) < 0.5) + (runif(n * p) < 0.5), ncol = p, nrow = n)
A <- (runif(n, min = 0, max = 1) < 0.3)
propensity <- runif(n, min = 0.4, max = 0.8)
Y <- runif(n) < 1/ (1 + exp(- 2 * X[, 5, drop = FALSE]))
auc_scores <- modified_outcome(A, X, Y, propensity,
                               ncores = 1, parallel = TRUE, n_subsample = 1)

}
\references{
Rosenbaum, Paul R., and Donald B. Rubin. 'The central role of
the propensity score in observational studies for causal effects.'
Biometrika 70.1 (1983): 41-55.
}
