% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export}
\alias{export}
\title{Export Data to Various File Formats}
\usage{
export(data, file_path, ...)
}
\arguments{
\item{data}{The dataset to be exported.}

\item{file_path}{Character string specifying the path to the output file.}

\item{...}{Additional arguments to be passed to the underlying write
functions. These arguments are specific to the file format being exported.
Please refer to the documentation of each package used for more
information.}
}
\value{
No return value, called for side effects.
}
\description{
This function provides a unified interface for exporting data to various
file formats supported by the \code{\link[=rio]{rio::export()}}
function. The format is automatically detected from the file extension to
simplify the exporting process.
}
\examples{
# Create temporary account
tmpdir <- tempfile()
dir.create(tmpdir)

# Export a CSV file
export(mtcars, file_path = file.path(tmpdir, "file.csv"))

# Export an Excel file
export(mtcars, file_path = file.path(tmpdir, "file.xlsx"))

# Export a Stata DTA file
export(mtcars, file_path = file.path(tmpdir, "file.dta"))

# Export an RDS file
export(mtcars, file_path = file.path(tmpdir, "file.rds"))

# Export an RData file
export(list(mtcars = mtcars, iris = iris),
       file_path = file.path(tmpdir, "file.RData"))

# Remove the temporary directory and its contents
unlink(tmpdir, recursive = TRUE)
}
\seealso{
\code{\link[=rio]{rio::export()}}, which this function is
based on.
}
