% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wimp_raw_to_metagenomeseq.R
\name{wimp_raw_to_metagenomeseq}
\alias{wimp_raw_to_metagenomeseq}
\title{Raw WIMP files plus metadata to metagenomeseq object}
\usage{
wimp_raw_to_metagenomeseq(
  path.to.wimp.files,
  metadata,
  keep.unclassified = FALSE,
  keep.human = FALSE
)
}
\arguments{
\item{path.to.wimp.files}{path to data of raw CSV files from
WIMP analysis}

\item{metadata}{dataframe of metadata with "filename" and "barcode"
columns required}

\item{keep.unclassified}{TRUE or FALSE: whether to keep reads that do not
classify below phylum, default = FALSE}

\item{keep.human}{TRUE or FALSE: whether to keep reads that are classified as
human, default = FALSE}
}
\value{
metagenomeseq object for downstream analysis with WIMP data
}
\description{
Given WIMP directory and metadata, make phyloseq
object. \pkg{\link{metagenomeSeq}} package required.
}
\examples{
\dontrun{
wimp_raw_to_metagenomeseq(path.to.wimp.files = path/to/wimpfiles,
metadata = metadata, keep.unclassified = FALSE, keep.human = FALSE)
}
}
\seealso{
\pkg{\link{metagenomeSeq}}
}
