% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epanet.rpt-s3.r
\name{plot.epanet.rpt}
\alias{plot.epanet.rpt}
\title{Plot Simulation Results}
\usage{
\method{plot}{epanet.rpt}(x, inp, Timestep = "0:00:00", juncQty = "Demand",
  linkQty = "Velocity", legend1.locn = "topright",
  legend2.locn = "topleft", ...)
}
\arguments{
\item{x}{epanet.rpt object}

\item{inp}{epanet.inp object associated with x}

\item{Timestep}{string indicating the time to plot}

\item{juncQty}{string specifying which column of x$nodeResults
(Demand, Head, Pressure, Chlorine, etc.) 
to show by circle size at network junctions or NULL
if no quantity should be plotted at the junctions}

\item{linkQty}{string specifying which column of x$linkResults
(Flow, Velocity, Headloss)
to show by line width on network links or NULL
if now quantity should be plotted for the links.}

\item{legend1.locn}{string passed to legend() for placing legend of network elements}

\item{legend2.locn}{string passed to legend() for placing legend of junction and link quantities}

\item{...}{further arguments passed to plot}
}
\description{
Plots simulation results for a single time step in map form
}
\details{
juncQty plots and values for Junctions only; Tanks and Reservoirs are not included.
         In contrast, linkQty is scaled over all of the link types: Pipes, Pumps & Valves.
         These choices aim at a map showing demand at junctions and velocity in links.
}
