% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSparklineTable.r
\name{plotSparklineTable}
\alias{plotSparklineTable}
\title{Plot Sparkline Table}
\usage{
plotSparklineTable(df, row.var, col.vars, xvar = NULL, xrange.labels = NULL)
}
\arguments{
\item{df}{data.frame of values to plot.}

\item{row.var}{variable for rows of the table}

\item{col.vars}{variables for columns of the table}

\item{xvar}{optional name of variable for horizontal axis of sparkline plots}

\item{xrange.labels}{optional vector of length 2 with labels for the first
and last quantities plotted on x-axis, often a date and/or time}
}
\description{
Generate a table of sparkline plots
}
\details{
Generates a table of 'sparkline' plots of data in df. rows the table correspond to 
        different values of row.var. The table's first column gives the value of row.var. The 
        remaining columns contain sparkline plots for the values of col.vars.  When xvar is not
        provided values are plotted against their index in the extracted vector. The starting
        and ending values are labeled. 
        Uses layout() function to arrange plots.
}
\examples{
plotSparklineTable( Orange, row.var = 'Tree', col.vars = c('age','circumference'))
plotSparklineTable( Loblolly, row.var = 'Seed', col.vars = 'height')
## specify the x variable if you have it, especially if it differs 
plotSparklineTable(Theoph, row.var = 'Subject', col.vars = 'conc')
## a warning is normally issued with the ranges of xvar differ 
suppressWarnings( plotSparklineTable(Theoph, row.var = 'Subject', col.vars = 'conc', xvar = 'Time'))
}
\references{
E. Tufte, Beautiful Evidence, Graphics Press, 2006.
}
\seealso{
yaletoolkit and sparkTable packages
}

