% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydraulics.r
\name{ENrunH}
\alias{ENrunH}
\title{run hydraulics engine}
\usage{
ENrunH()
}
\description{
\code{ENrunH} Runs a single period hydraulic analysis, retrieving the 
current simulation clock time \code{t}.
}
\details{
Use \code{ENrunH} along with \code{ENnextH} in a while loop to 
  analyze hydraulics in each period of an extended period simulation. 
  This process automatically updates the simulation clock time so treat 
  \code{t} as a read-only variable.
  
  \code{ENinitH} must have been called prior to running the 
  \code{ENrunH-ENnextH} loop.
  
  See \code{ENnextH} for an example of using this function.
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENopenH()
ENinitH(0)
ENrunH()
ENcloseH()
ENclose()
}
\seealso{
\code{ENopenH}, \code{ENinitH}, \code{ENnextH}, \code{ENcloseH}
}
