% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydraulics.r
\name{ENnextH}
\alias{ENnextH}
\title{determine the next hydraulic step}
\usage{
ENnextH()
}
\value{
An integer, the time (in seconds) until next hydraulic event 
  occurs or 0 if at the end of the simulation period.
}
\description{
\code{ENnextH} determines the length of time until the next 
hydraulic event occurs in an extended period simulation.
}
\details{
This function is used in conjunction with \code{ENrunH} to 
  perform an extended period hydraulic analysis (see example below).
  
  The return value is automatically computed as the smaller of:
  
  \itemize{
  \item the time interval until the next hydraulic time step begins
  \item the time interval until the next reporting time step begins
  \item the time interval until the next change in demands occurs
  \item the time interval until a tank becomes full or empty
  \item the time interval until a control or rule fires
  }
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
  # store simulation times
  t = NULL
  ENopenH()
  ENinitH(11)
  repeat {
    t <- c(t, ENrunH())
    tstep <- ENnextH()
    if (tstep == 0) {
      break
    }
  }
  ENcloseH()
  ENclose()
  
}
\seealso{
\code{ENopenH}, \code{ENinitH}, \code{ENrunH}, \code{ENcloseH}, \code{ENsettimeparam}
}
