% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StockMarketScreenerAPI.R
\name{stock_market_screener}
\alias{stock_market_screener}
\title{Stock market screener}
\usage{
stock_market_screener(
  api_token,
  sort = NULL,
  filters = NULL,
  limit = NULL,
  signals = NULL,
  offset = NULL
)
}
\arguments{
\item{api_token}{The API token for authentication.}

\item{sort}{Sorts all fields with type ‘Number’ in ascending/descending order.}

\item{filters}{Filters out tickers by different fields.}

\item{limit}{The number of results should be returned with the query.}

\item{signals}{Filter out tickers by signals, the calculated fields.}

\item{offset}{The offset of the data.}
}
\value{
A list containing the stock market screener.
}
\description{
This function retrieves stock market screener from the API.
}
\examples{
api_token <- "demo"
sort <- "market_capitalization.desc"
filters <- NULL
limit <- "1"
signals <- "bookvalue_neg"
offset <- "50"
result <- stock_market_screener(api_token, sort, filters, limit, signals, offset)

}
