% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{destandardize_env_name}
\alias{destandardize_env_name}
\title{De-standardize the name of an environment}
\usage{
destandardize_env_name(env_name)
}
\arguments{
\item{env_name}{environment name to de-standardize.}
}
\value{
The name of the environment, where the global environment is represented as ".GlobalEnv", the empty
environment as ".EmptyEnv", and the base environment as "package:base".
}
\description{
This function inverts the process performed by \link{standardize_env_name} that is, it converts
the standardized names "R_GlobalEnv", "R_EmptyEnv", and "base" back to names that are recognized by R as actual
environments when using function \link{as.environment}, namely to \code{".GlobalEnv"}, \code{".EmptyEnv"},
and \code{"package:base"}.
}
\keyword{internal}
