% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{check_object_with_path}
\alias{check_object_with_path}
\title{Check if an object name contains a valid environment path}
\usage{
check_object_with_path(x, checkenv = FALSE, envir = NULL)
}
\arguments{
\item{x}{string to be checked.}

\item{checkenv}{flag indicating whether the environment path should be checked for valid environment
as well. Defaults to FALSE.}

\item{envir}{environment where \code{x} should be evaluated when also checking the environment.
Only used when \code{checkenv=TRUE}.}
}
\value{
A list containing the following elements:

When \code{checkenv=FALSE}:
\itemize{
\item{\code{ok}} boolean indicating whether the string may be a valid object name
\item{\code{path}} path to the name
\item{\code{name}} the name itself with no path.
}

When \code{checkenv=TRUE} and when the string given in \code{x} is deemed to be a possible valid object,
the following additional elements:
\itemize{
\item{\code{env_found}} flag indicating whether the string indicating the path to the object name
referenced by \code{x} is the name of an existing environment in the workspace
\item{\code{env_name}} the name of the environment (after stripping out any system environments such
as globalenv(), baseenv() or a package environment) (for instance "globalenv()$env$env1" is returned
as "env$env1"), or NULL if no environment is found corresponding to the path given in \code{x}.
}
}
\description{
Check if a string may represent a valid object name with full environment path to the object
as in \code{globalenv()$env$x}. The string should \emph{not} end with \code{]} or \code{)} because
that makes the whole expression an invalid name and therefore it should not be considered as a name
(e.g. \code{globalenv()$v[1]} refers to element 1 of array v and such thing is not the name of an object).
}
\details{
Optionally a check of whether the path points to a valid environment inside a given environment
is performed by calling \code{}.
}
\keyword{internal}
