% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETsolradRasters.R
\name{ETsolradRasters}
\alias{ETsolradRasters}
\title{Extraterrestrial Solar Radiation}
\usage{
ETsolradRasters(rasterTemplate, year, outputDir = NULL, ...)
}
\arguments{
\item{rasterTemplate}{any rasterLayer that can be used to extract 
extent, resolution, projection, etc.}

\item{year}{The year solar radiation should be calculated for. See details.}

\item{outputDir}{destination directory for rasters, can be \code{NULL}}

\item{...}{additional arguments passed to \code{writeRaster}}
}
\value{
If \code{outputDir = NULL}, a RasterStack is returned. Otherwise, rasters
	are written to disk in the designated directory, and nothing is returned. 
	Naming of the layers uses the tag specified via \code{\link{assignNames}}.
}
\description{
Generate monthly extraterrestrial solar radiation rasters.
}
\details{
Given the latitude values of the cells found in the raster template
	and the year, monthly extraterrestrial solar radiation can be calculated,
	using the palinsol R package. \code{year = 0} corresponds to 1950. 
	Although the year can take on any value, it should match the time period 
	of the other rasters that will be used for generating ENVIREM variables. 
	Suggestions would be \code{year = 40} for the present, \code{year = -6000} 
	for the mid Holocene, and \code{year = -21500} for the LGM.
	
	If you are having problems with this function and the rasterTemplate is not in 
	long/lat, try with an unprojected long/lat raster.
}
\examples{
\donttest{
# Find example rasters
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)
env <- stack(rasterFiles)

# set aside a template raster
template <- env[[1]]

# generate solar radiation for the present
solrad <- ETsolradRasters(template, year = 40, outputDir = NULL)

}
}
\references{
J. Laskar et al., A long-term numerical solution for the insolation quantities of the Earth, 
\emph{Astron. Astroph.}, \strong{428}, 261-285  2004.
}
\author{
Pascal Title
}
