% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getmzrt.R
\name{getmzrt}
\alias{getmzrt}
\title{Get the mzrt profile and group information as a mzrt list and/or save them as csv or rds for further analysis.}
\usage{
getmzrt(
  xset,
  name = NULL,
  mzdigit = 4,
  rtdigit = 1,
  method = "medret",
  value = "into",
  eic = F,
  type = "o"
)
}
\arguments{
\item{xset}{xcmsSet/XCMSnExp objects}

\item{name}{file name for csv and/or eic file, default NULL}

\item{mzdigit}{m/z digits of row names of data frame, default 4}

\item{rtdigit}{retention time digits of row names of data frame, default 1}

\item{method}{parameter for groupval or featureDefinitions function, default medret}

\item{value}{parameter for groupval or featureDefinitions function, default into}

\item{eic}{logical, save xcmsSet and xcmsEIC objects for further investigation with the same name of files, you will need raw files in the same directory as defined in xcmsSet to extract the EIC based on the binned data. You could use `plot` to plot EIC for specific peaks. For example, `plot(xcmsEIC,xcmsSet,groupidx = 'M123.4567T278.9')` could show the EIC for certain peaks with m/z 206 and retention time 2789. default F}

\item{type}{csv formate for furthor analysis, m means  Metaboanalyst, a means xMSannotator, p means Mummichog(NA values are imputed by `getimputation`, and F test is used here to generate stats and p vlaue), o means full infomation csv (for `pmd` package), default o. mapo could output all those format files.}
}
\value{
mzrt object, a list with mzrt profile and group infomation
}
\description{
Get the mzrt profile and group information as a mzrt list and/or save them as csv or rds for further analysis.
}
\examples{
\dontrun{
library(faahKO)
cdfpath <- system.file('cdf', package = 'faahKO')
xset <- getdata(cdfpath, pmethod = ' ')
getmzrt(xset, name = 'demo', type = 'mapo')
}
}
\references{
Smith, C.A., Want, E.J., O’Maille, G., Abagyan, R., Siuzdak, G., 2006. XCMS: Processing Mass Spectrometry Data for Metabolite Profiling Using Nonlinear Peak Alignment, Matching, and Identification. Anal. Chem. 78, 779–787.
}
\seealso{
\code{\link{getdata}},\code{\link{getdata2}}, \code{\link{getdoe}}, \code{\link{getcsv}}, \code{\link{getfilter}}
}
