% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{getmzrt2}
\alias{getmzrt2}
\title{Get the mzrt profile and group information for batch correction and plot as a list for xcms 3 object}
\usage{
getmzrt2(xset, name = NULL)
}
\arguments{
\item{xset}{a XCMSnExp object with processed data}

\item{name}{file name for csv file, default NULL}
}
\value{
list with rtmz profile and group infomation
}
\description{
Get the mzrt profile and group information for batch correction and plot as a list for xcms 3 object
}
\examples{
\dontrun{
library(faahKO)
cdfpath <- system.file('cdf', package = 'faahKO')
xset <- getdata2(cdfpath,
ppp = xcms::MatchedFilterParam(),
rtp = xcms::ObiwarpParam(),
gpp = xcms::PeakDensityParam())
getmzrt2(xset)
}
}
\seealso{
\code{\link{getdata2}},\code{\link{getupload2}}, \code{\link{getmzrt}}, \code{\link{getdoe}},\code{\link{getmzrtcsv}}
}
