% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_selected.R
\name{predict_selected}
\alias{predict_selected}
\title{Predictions for the models selected after calibration}
\usage{
predict_selected(fitted, newdata, clamping = FALSE, var_to_clamp = NULL,
                 type = "response", consensus = TRUE)
}
\arguments{
\item{fitted}{a list of GLMs obtained using the
functions \code{\link{fit_selected}} or \code{\link{fit_glms}}.}

\item{newdata}{a \code{SpatRaster}, data.frame, or matrix with the new data on
which to predict.}

\item{clamping}{(logical) this option controls extrapolation when making
predictions for environmental conditions beyond the calibration data.
Default = FALSE.}

\item{var_to_clamp}{(character) a vector containing the names of the variables
that will undergo clamping. By default, if no specific names are provided,
the value is set to NULL, which indicates that clamping will be applied to
all variables. Ignore if clamping = FALSE.}

\item{type}{(character) the type of prediction required. For a default
binomial model the default predictions are of log-odds (probabilities on
logit scale). The default, "response", returns predicted probabilities.}

\item{consensus}{(logical) valid if \code{newdata} is a \code{SpatRaster}, whether to
produce consensus results obtained by combining the predictions from the
collection of selected models. By default consensuses are calculated using
the mean, median, a weighted average using the AIC weights, and variance.
Default = TRUE.}
}
\value{
A list with predictions of selected models on the \code{newdata} and fitted
selected model(s). Consensus predictions are added if multiple selected
models exits and if \code{newdata} is a \code{SpatRaster} object.
}
\description{
Wrapper function that facilitates the prediction of those models
selected as the most robust. In addition, it allows the calculation of
consensus models, when more than one model are selected.
}
\examples{
# Load a fitted selected model
data(sel_fit, package = "enmpa")

# Load raster layers to be projected
env_vars <- terra::rast(system.file("extdata", "vars.tif", package = "enmpa"))

# Predictions (only one selected mode, no consensus required)
preds <- predict_selected(sel_fit, newdata = env_vars, consensus = FALSE)

# Plot prediction
terra::plot(preds$predictions)
}
