% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation_stats.R
\name{evaluation_stats}
\alias{evaluation_stats}
\title{Summary of evaluation statistics for candidate models}
\usage{
evaluation_stats(evaluation_results, bimodal_toexclude = FALSE)
}
\arguments{
\item{evaluation_results}{data.frame model evaluation results. These results
are the output of the function \code{\link{model_validation}}.}

\item{bimodal_toexclude}{(logical) whether models in which binomial variable
response curves were detected will be excluded during selection processes.}
}
\value{
A data.frame with the mean and standard deviation for all metrics considering
cross-validation kfolds.
}
\description{
Calculate median and standard deviation of evaluation results for all
candidate models considering cross-validation kfolds.
}
\examples{
# data
data("cal_res", package = "enmpa")
all_res <- cal_res$calibration_results[, -1]

# statistics for all evaluation results
eval_stats <- evaluation_stats(all_res, bimodal_toexclude = TRUE)
}
