% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worstlosses.R
\name{worstlosses}
\alias{worstlosses}
\title{Return each team's worst losses}
\usage{
worstlosses(df = NULL, teamname = NULL, type = NULL, N = NULL)
}
\arguments{
\item{df}{the results dataset}

\item{teamname}{team name}

\item{type}{If \code{=NULL} then all results are returned. If
Otherwise valid types are \code{H}, \code{A}
relating to home-losses, away-losses}

\item{N}{The total number of games to return}
}
\value{
a dataframe of games ending in worst losses
}
\description{
Return each team's worst losses
}
\examples{
worstlosses(england,"Everton")
worstlosses(england,"Aston Villa", type="H")
worstlosses(england,"York City", type="A")
worstlosses(england,"Port Vale", N=20)
worstlosses(england,"Hull City", type="A", N=7)

}

