% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engressionfit.R
\name{engressionfit}
\alias{engressionfit}
\title{Engression Fit Function}
\usage{
engressionfit(
  X,
  Y,
  noise_dim = 100,
  hidden_dim = 100,
  num_layer = 3,
  dropout = 0.01,
  num_epochs = 200,
  lr = 10^(-3),
  beta = 1,
  silent = FALSE
)
}
\arguments{
\item{X}{A matrix or data frame representing the predictors.}

\item{Y}{A matrix or vector representing the target variable(s).}

\item{noise_dim}{The dimension of the noise introduced in the model (default: 100).}

\item{hidden_dim}{The size of the hidden layer in the model (default: 100).}

\item{num_layer}{The number of layers in the model (default: 3).}

\item{dropout}{The dropout rate to be used in the model (default: 0.01).}

\item{num_epochs}{The number of epochs to be used in training (default: 200).}

\item{lr}{The learning rate to be used in training (default: 10^-3).}

\item{beta}{The beta scaling factor for energy loss (default: 1).}

\item{silent}{A boolean indicating whether to suppress output during model training (default: FALSE).}
}
\value{
A list containing the trained engression model and a vector of loss values.
}
\description{
This function fits an Engression model to the provided data. It allows for the tuning of
several parameters related to model complexity and training. The function is not meant to
be exported but can be used within the package or for internal testing purposes.
}
\keyword{internal}
