% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decrypt.R
\name{decrypt_vec}
\alias{decrypt_vec}
\title{Decrypt ciphertext using an RSA public/private key}
\usage{
decrypt_vec(.data, private_key_path = "id_rsa")
}
\arguments{
\item{.data}{A vector of ciphertexts created using \code{\link{encrypt}}.}

\item{private_key_path}{Character. A quoted path to an RSA private key
created using \code{\link{genkeys}}.}
}
\value{
A character vector.
}
\description{
Not usually called directly. Password for private key required.
}
\examples{
\dontrun{
hospital_number = c("1010761111", "2010761212")
genkeys(file.path(tempdir(), "id_rsa") # temp directory for testing only
hospital_number_encrypted = encrypt_char(hospital_number)
decrypt_vec(hospital_number_encrypted)
}
}
