% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-bas_webservices.R
\name{runBASwebservice_g2pForTokenization}
\alias{runBASwebservice_g2pForTokenization}
\title{Tokenizes an orthographic transcription.}
\usage{
runBASwebservice_g2pForTokenization(handle,
  transcriptionAttributeDefinitionName, language,
  orthoAttributeDefinitionName = "ORT", params = list(), resume = FALSE,
  verbose = TRUE)
}
\arguments{
\item{handle}{emuDB handle}

\item{transcriptionAttributeDefinitionName}{name of the attribute (not level!) containing an orthographic transcription.}

\item{language}{language(s) to be used. If you pass a single string (e.g. "deu-DE"), this language will be used for all bundles.
Alternatively, you can select the language for every bundle individually. To do so, you must pass a data frame with the columns
session, bundle, language. This data frame must contain one row for every bundle in your emuDB.
Up-to-date lists of the languages accepted by all webservices can be found here:
\url{https://clarin.phonetik.uni-muenchen.de/BASWebServices/services/help}}

\item{orthoAttributeDefinitionName}{attribute name for orthographic words}

\item{params}{named list of parameters to be passed on to the webservice. It is your own reponsibility to
ensure that these parameters are compatible with the webservice API
(see \url{https://clarin.phonetik.uni-muenchen.de/BASWebServices/services/help}).
Some options accepted by the API (e.g. output format) cannot be set when calling a webservice from within emuR,
and will be overridden.}

\item{resume}{If a previous call to this function has failed (and you think you have fixed the issue
that caused the error), you can set resume=TRUE to recover any progress made up to that point. This
will only work if your R temporary directory has not been deleted or emptied in the meantime.}

\item{verbose}{Display progress bars and other information}
}
\description{
This function calls the webservice G2P to break up a transcription into tokens, or words.
In addition to tokenization, G2P performs normalization of numbers and other special words.
A call to this function is usually followed by a call to \link{runBASwebservice_g2pForPronunciation}.
\strong{This function requires an internet connection.}
}
\details{
All necessary level, link and attribute definitions are created in the process.
}
\seealso{
Other BAS webservice functions: \code{\link{runBASwebservice_all}},
  \code{\link{runBASwebservice_chunker}},
  \code{\link{runBASwebservice_g2pForPronunciation}},
  \code{\link{runBASwebservice_maus}},
  \code{\link{runBASwebservice_minni}},
  \code{\link{runBASwebservice_pho2sylCanonical}},
  \code{\link{runBASwebservice_pho2sylSegmental}}
}
