% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-convert_TextGridCollection.R
\name{convert_TextGridCollection}
\alias{convert_TextGridCollection}
\title{Convert a TextGridCollection (e.g. .wav & .TextGrid files) to emuDB}
\usage{
convert_TextGridCollection(dir, dbName, targetDir, tgExt = "TextGrid",
  audioExt = "wav", tierNames = NULL, verbose = TRUE)
}
\arguments{
\item{dir}{path to directory containing the TextGridCollection (nested directory structures are permitted as the 
function recursively searches through directories, generating the session names from dir. structure)}

\item{dbName}{name given to the new emuDB}

\item{targetDir}{directory where to save the new emuDB}

\item{tgExt}{extension of TextGrid files (default=TextGrid, meaning file names of the form baseName.TextGrid)}

\item{audioExt}{extension of audio files (default=wav, meaning file names of the form baseName.wav)}

\item{tierNames}{character vector containing names of tiers to extract and convert. If NULL (the default) all
tiers are converted.}

\item{verbose}{display infos & show progress bar}
}
\description{
Converts a TextGridCollection to an emuDB by searching a given directory for .wav & .TextGrid files (default
extensions) with the same base name. First, the function generates a file pair list 
containing paths to files with the same base
name. It then generates an emuDB DBconfig based on the first TextGrid in this list which specifies 
the allowed level names and types in the new emuDB. After this it converts all file pairs to the new format,
checking whether they comply to the newly generated database configuration. For 
more information on the emuDB format see \code{vignette{emuDB}}.
Note that since Praat TextGrids do not permit explicit hierarchical structures, the created emuDB does not contain
any links or link definitions. You can however use the \code{\link{autobuild_linkFromTimes}} function after the conversion process
to automatically build a hierarchal structure.
}
\examples{
\dontrun{

##########################################################
# prerequisite: directory containing .wav & .TextGrid files
# (see \\code{?create_emuRdemoData} how to create demo data)

# convert TextGridCollection and store 
# new emuDB in folder provided by tempdir()
convert_TextGridCollection(dir = "/path/to/directory/",
                           dbName = "myTGcolDB",
                           targetDir = tempdir())


# same as above but this time only convert 
# the information stored in the "Syllable" and "Phonetic" tiers
convert_TextGridCollection(dir = "/path/to/directory/", 
                           dbName = "myTGcolDB", 
                           targetDir = tempdir(),
                           tierNames = c("Syllable", "Phonetic"))

} 
}

