% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC-support.R
\name{hpd.summary}
\alias{hpd.summary}
\title{Summarize an emmGrid from a Bayesian model}
\usage{
hpd.summary(object, prob, by, type, point.est = median,
  bias.adjust = get_emm_option("back.bias.adj"), sigma, ...)
}
\arguments{
\item{object}{an \code{emmGrid} object having a non-missing \code{post.beta} slot}

\item{prob}{numeric probability content for HPD intervals (note: when not specified,
the current \code{level} option is used; see \code{\link{emm_options}})}

\item{by}{factors to use as \code{by} variables}

\item{type}{prediction type as in \code{\link{summary.emmGrid}}}

\item{point.est}{function to use to compute the point estimates from the 
posterior sample for each grid point}

\item{bias.adjust}{Logical value for whether to adjust for bias in
back-transforming (\code{type = "response"}). This requires a value of 
\code{sigma} to exist in the object or be specified.}

\item{sigma}{Error SD assumed for bias correction (when 
\code{type = "response"}. If not specified,
\code{object@misc$sigma} is used, and an error is thrown if it is not found.
\emph{Note:} \code{sigma} may be a vector, as long as it conforms to the 
number of observations in the posterior sample.}

\item{...}{required but not used}
}
\value{
an object of class \code{summary_emm}
}
\description{
This function computes point estimates and HPD intervals for each
factor combination in \code{object@emmGrid}. While this function
may be called independently, it is called utomatically by the S3 method
\code{\link{summary.emmGrid}} when the object is based on a Bayesian model.
(Note: the \code{level} argument, or its default, is passed as \code{prob}).
}
\examples{
if(require("coda")) {
  # Create an emmGrid object from a system file
  cbpp.rg <- do.call(emmobj, 
      readRDS(system.file("extdata", "cbpplist", package = "emmeans")))
  hpd.summary(emmeans(cbpp.rg, "period"))
}

}
\seealso{
summary.emmGrid
}
