% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.nests.R
\name{info.nests}
\alias{info.nests}
\title{Calculte statistics about nests}
\usage{
info.nests(x = NULL, parameters = NULL, NestsResult = NULL,
  resultmcmc = NULL, hessian = NULL, CI = NULL,
  fixed.parameters = NULL, SE = NULL, temperatures = NULL,
  derivate = NULL, test = NULL, stopattest = FALSE, M0 = NULL,
  series = "all", TSP.borders = NULL,
  embryo.stages = "Generic.ProportionDevelopment", TSP.begin = 0,
  TSP.end = 0.5, replicate.CI = 100, weight = NULL,
  out = "likelihood", fill = NULL, SexualisationTRN = NULL,
  SexualisationTRN.mcmc = NULL, SexualisationTRN.CI = NULL,
  metric.end.incubation = NA, metabolic.heating = 0,
  temperature.heterogeneity = 0, progress = FALSE, warnings = TRUE,
  parallel = TRUE, tsd = NULL)
}
\arguments{
\item{x}{A set of parameters to model the embryo growth thermal reaction norm or a NestsResult object.}

\item{parameters}{A set of parameters to model the embryo growth thermal reaction norm. It will replace the parameters included in NestsResult (same as x).}

\item{NestsResult}{A NestsResult object generated by searchR to model the embryo growth thermal reaction}

\item{resultmcmc}{A mcmc result for embryo growth thermal reaction norm}

\item{hessian}{An hessian matrix for embryo growth thermal reaction norm. It will replace the hessian matrix included in NestResult object.}

\item{CI}{How to estimate CI for embryo growth thermal reaction norm; can be NULL, "SE", "MCMC", or "Hessian".}

\item{fixed.parameters}{A set of fixed parameters to model the embryo growth thermal reaction norm. It will replace the fixed parameters included in NestsResult.}

\item{SE}{Standard error for each parameter. It will replace the SE in NestsResult. Use SE=NA to remove SE from NestResult}

\item{temperatures}{Timeseries of temperatures formatted using formatNests(). It will replace the one in NestsResult.}

\item{derivate}{Function used to fit embryo growth: dydt.Gompertz, dydt.exponential or dydt.linear. It will replace the one in NestsResult.}

\item{test}{Mean and SD of size of hatchlings. It will replace the one in NestsResult.}

\item{stopattest}{TRUE or FALSE. If TRUE, the model stops when proxy of size reached the mean test size.}

\item{M0}{Measure of hatchling size proxi at laying date. It will replace the one in NestsResult.}

\item{series}{The name or number of the series to be estimated.}

\item{TSP.borders}{The limits of TSP in stages. See embryo.stages parameter.}

\item{embryo.stages}{The embryo stages. At least TSP.borders stages must be provided to estimate TSP borders. See note.}

\item{TSP.begin}{Where TSP begin during the stage of beginning? In relative proportion of the stage.}

\item{TSP.end}{Where TSP begin during the stage of ending? In relative proportion of the stage.}

\item{replicate.CI}{Number of replicates to estimate CI. If <2, no CI is estimated.}

\item{weight}{Weights of the different nests to estimate likelihood. It will replace the one in NestsResult.}

\item{out}{Can take the values of "likelihood" or "metric" or "summary". "metric" and "summary" can be combined: c("metric", "summary")}

\item{fill}{Number of minutes between two records. Create new one if they do not exist. NULL does not change the time of temperature recordings.}

\item{SexualisationTRN}{A set of parameters used to model sexualisation thermal reaction norm during TSP or a result of STRN()}

\item{SexualisationTRN.mcmc}{A mcmc object obtained from STRN_MHmcmc() to generate variability for sexualisation thermal reaction norm during TSP}

\item{SexualisationTRN.CI}{How to estimate CI of sexualisation thermal reaction norm. Can be NULL, "SE", "MCMC", or "Hessian".}

\item{metric.end.incubation}{The expected metric at the end of incubation. Used to calibrate TSP size. If NULL, take the maximum Mean of the test parameter. If NA, use the actual final size. Can be a vector and is recycled if necessary.}

\item{metabolic.heating}{Degrees Celsius to be added at the end of incubation due to metabolic heating.}

\item{temperature.heterogeneity}{SD of heterogeneity of temperatures. Can be 2 values, sd_low and sd_high and then HelpersMG::r2norm() is used.}

\item{progress}{If FALSE, the progress bar is not shown (useful for using with sweave or knitr)}

\item{warnings}{If FALSE, does not show warnings}

\item{parallel}{If TRUE use parallel version for nests estimation}

\item{tsd}{A object from tsd() that describe the thermal react norm of sex ratio at constant temperatures}
}
\value{
Return or the total likelihood or a list with $metric and $summary depending on out parameter
}
\description{
This function calculates many statistics about nests.\cr
The embryo.stages is a named vector with relative size as compared to final size at the beginning of the stage. Names are the stages.\cr
For example for SCL in Caretta caretta:\cr
embryo.stages=structure(c(8.4, 9.4, 13.6, 13.8, 18.9, 23.5, 32.2, 35.2, 35.5, 38.5)/39.33), \cr
.Names = c("21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"))\cr
 indicates that the stages 21 begins at the relative size of 8.4/39.33.\cr
Series can be indicated as the name of the series, their numbers or series or sucession of TRUE or FALSE. "all" indicates that all series must be analyzed.\cr
The likelihood object is just the total likelihood of the data in the model.\cr
If one parameter is named "pipping_emergence" it is used as the number of days between pipping and emergence to calculate the 1/3 and 2/3 of incubation.\cr
The summary object is a data.frame composed of these elements:
\itemize{
  \item \code{Temperature.max} Maximum temperature recorded during incubation
  \item \code{TimeWeighted.temperature.mean} Average temperature weigthed by the time at each temperature for all incubation
  \item \code{TimeWeighted.temperature.se} Standard error for the average temperature weigthed by the time at each temperature for all incubation
  \item \code{MassWeighted.temperature.mean} Average temperature weigthed by the growth of embryo for all incubation
  \item \code{MassWeighted.temperature.se} Standard error for the average temperature weigthed by the growth of embryo for all incubation
  \item \code{TSP.TimeWeighted.temperature.mean} Average temperature during the TSP weigthed by the time at each temperature
  \item \code{TSP.TimeWeighted.temperature.se} Standard error for the average temperature during the TSP weigthed by the time at each temperature
  \item \code{TSP.MassWeighted.temperature.mean} Average temperature during the TSP weigthed by the mass increase at each temperature
  \item \code{TSP.MassWeighted.temperature.se} Standard error for the average temperature during the TSP weigthed by the mass increase at each temperature
  \item \code{TSP.STRNWeighted.temperature.mean} Averaged temperature during the TSP weighted by sexualisation thermal reaction norm
  \item \code{TSP.STRNWeighted.temperature.se} Standard error for temperature during the TSP weighted by sexualisation thermal reaction norm
  \item \code{TSP.MassWeighted.STRNWeighted.temperature.mean} Averaged temperature during the TSP weighted by sexualisation thermal reaction norm and embryo growth
  \item \code{TSP.MassWeighted.STRNWeighted.temperature.se} Standard error for temperature during the TSP weighted by sexualisation thermal reaction norm and embryo growth
  \item \code{TSP.length.mean} Average length of the TSP
  \item \code{TSP.length.se} Standard error for length of the TSP
  \item \code{TSP.begin.mean} Average time of the beginning of the TSP
  \item \code{TSP.begin.se} Standard error for the beginning of the TSP
  \item \code{TSP.end.mean} Average time of the endd of the TSP
  \item \code{TSP.end.se} Standard error for the end of the TSP
  \item \code{PM.mean} Proportion of males based on Massey et al. 2019
  \item \code{PM.se} Standard error for the proportion of males based on Massey et al. 2019
  \item \code{PM.TimeWeighted.mean} Proportion of males with time effect
  \item \code{PM.TimeWeighted.se} Standard error for the proportion of males with time effect
  \item \code{Incubation.length.mean} Average number of days for the incubation length
  \item \code{Incubation.length.se} Standard error for number of days for the incubation length
  \item \code{Middlethird.begin.mean} Average day at which the middle third incubation begins
  \item \code{Middlethird.begin.se} Standard error for day at which the middle third incubation begins
  \item \code{Middlethird.end.mean} Average day at which the middle third incubation ends
  \item \code{Middlethird.end.se} Standard error at which the middle third incubation ends
  \item \code{Middlethird.length.mean} Average days for second third of incubation
  \item \code{Middlethird.length.se} Standard error for second third of incubation
  \item \code{MiddleThird.TimeWeighted.temperature.mean} Average temperature during the middle third of incubation
  \item \code{MiddleThird.TimeWeighted.temperature.se} Standard error for the temperature during the middle third of incubation
  \item \code{MiddleThird.MassWeighted.temperature.mean} Average temperature during the middle third of incubation weighted by embryo growth
  \item \code{MiddleThird.MassWeighted.temperature.se} Standard error for temperature during the middle third of incubation weighted by embryo growth
}
The metric object is a list composed of data.frames which have the following attributes for each element of the list:
\itemize{
  \item \code{time.begin.tsp} Average time at the beginning of TSP
  \item \code{time.end.tsp} Average time at the end of TSP
  \item \code{time.begin.middlethird} Average time at the beginning of the middle third of incubation
  \item \code{time.begin.middlethird} Average time at the end of the middle third of incubation
  \item \code{time.begin.tsp.se} Standard error for the time at the beginning of TSP
  \item \code{time.end.tsp.se} Standard error for the time at the end of TSP
  \item \code{time.begin.middlethird.se} Standard error for the time at the beginning of the middle third of incubation
  \item \code{time.end.middlethird.se} Standard error for the time at the end of the middle third of incubation
  \item \code{stopattest} NA if stopattest was false, TRUE if at least one incubation series was longer than hatchling size and FALSE at contrary
}
If you indicate new set of temperatures, you must probably also indicate new test values.\cr
Note: four species have predefined embryo stages. embryo.stages parameter can take the values:\cr
\itemize{
  \item \code{Caretta caretta.SCL}
  \item \code{Chelonia mydas.SCL}
  \item \code{Emys orbicularis.SCL}
  \item \code{Emys orbicularis.mass}
  \item \code{Podocnemis expansa.SCL}
  \item \code{Generic.ProportionDevelopment}
  }
But remember that mass is not the best proxy to describe the growth of an embryo because it can decrease if the subtrate becomes dry.\cr
The progress bar is based on both replicates and timeseries.
}
\details{
Calculate statistics about nests
}
\examples{
\dontrun{
library(embryogrowth)
data(resultNest_4p_SSM4p)
summary.nests <- info.nests(resultNest_4p_SSM4p, out="summary", 
  embryo.stages="Caretta caretta.SCL", 
  replicate.CI=100, 
  resultmcmc=resultNest_mcmc_4p_SSM4p, 
  CI="MCMC", 
  progress=TRUE)
  # Result is in summary.nests$summary
infoall <- info.nests(resultNest_4p_SSM4p)
  # Result is a value
infoall.df <- info.nests(resultNest_4p_SSM4p, out="metric", 
  embryo.stages="Caretta caretta.SCL", 
  replicate.CI=100, 
  resultmcmc=resultNest_mcmc_4p_SSM4p, 
  CI="MCMC", 
  progress=TRUE)
# Result is in summary.nests$metric
infoall.both <- info.nests(resultNest_4p_SSM4p, 
  embryo.stages="Caretta caretta.SCL", 
  out=c("metric", "summary"), replicate.CI=100, 
  resultmcmc=resultNest_mcmc_4p_SSM4p, 
  CI="MCMC", 
  progress=TRUE)
# Results are in summary.nests$summary and in summary.nests$metric
infoall.both <- info.nests(resultNest_4p_SSM4p, 
  embryo.stages="Caretta caretta.SCL", 
  out=c("metric", "summary"), replicate.CI=100, 
  CI="Hessian", 
  progress=TRUE)
infoall.both <- info.nests(resultNest_4p_SSM4p, 
  embryo.stages="Caretta caretta.SCL", 
  out=c("metric", "summary"), replicate.CI=100, 
  CI="SE", 
  progress=TRUE)
# Example of use of embryo.stages and TSP.borders:
  summary.nests <- info.nests(resultNest_4p_SSM4p, out="summary", 
                            embryo.stages=c("10"=0.33, "11"=0.33, "12"=0.66, "13"=0.66), 
                            TSP.borders = c(10, 12), 
                            replicate.CI=100,
                            progress=TRUE)
                            
#########################################
# Sex ratio using Massey et al. method PM
#########################################

# Massey, M.D., Holt, S.M., Brooks, R.J., Rollinson, N., 2019. Measurement 
# and modelling of primary sex ratios for species with temperature-dependent 
# sex determination. J Exp Biol 222, 1-9.
  
CC_Mediterranean <- subset(DatabaseTSD, RMU=="Mediterranean" & 
Species=="Caretta caretta" & (!is.na(Sexed) & Sexed!=0))
tsdL <- with (CC_Mediterranean, tsd(males=Males, females=Females, 
                                    temperatures=Incubation.temperature, 
                                    equation="logistic", replicate.CI=NULL))
                                    
PM <- info.nests(resultNest_4p_SSM4p, 
  embryo.stages="Caretta caretta.SCL", replicate.CI=100, 
  CI="Hessian", 
  out="summary", progress=TRUE, tsd=tsdL)
  
sr_TSP_SCLW <- predict(tsdL, temperatures=PM$summary[, "TSP.MassWeighted.temperature.mean"], 
              temperature.se=PM$summary[, "TSP.MassWeighted.temperature.se"])

plot_errbar(x=sr_TSP_SCLW["50\%", ], y=PM$summary[, "PM.mean"], 
            x.minus=sr_TSP_SCLW["2.5\%", ], 
            x.plus=sr_TSP_SCLW["97.5\%", ], 
            errbar.y=2*PM$summary[, "PM.se"], xlab="CTE SCL growth", 
            ylab="PM Massey et al. 2016", xlim=c(0, 1), ylim=c(0, 1), las=1)
segments(x0=0, y0=0, x1=1, y1=1, lty=2, col="red")

sr_TSP_TW <- predict(tsdL, temperatures=PM$summary[, "TSP.TimeWeighted.temperature.mean"], 
              temperature.se=PM$summary[, "TSP.TimeWeighted.temperature.se"])
              
plot_errbar(x=sr_TSP_TW["50\%", ], y=PM$summary[, "PM.mean"], 
            x.minus=sr_TSP_TW["2.5\%", ], 
            x.plus=sr_TSP_TW["97.5\%", ], 
            errbar.y=2*PM$summary[, "PM.se"], xlab="CTE Time", 
            ylab="PM Massey et al. 2016", xlim=c(0, 1), ylim=c(0, 1), las=1)
segments(x0=0, y0=0, x1=1, y1=1, lty=2, col="red")

plot_errbar(x=sr_TSP_TW["50\%", ], y=sr_TSP_SCLW["50\%", ], 
            x.minus=sr_TSP_TW["2.5\%", ], 
            x.plus=sr_TSP_TW["97.5\%", ], 
            y.minus=sr_TSP_SCLW["2.5\%", ], 
            y.plus=sr_TSP_SCLW["97.5\%", ], xlab="CTE Time", 
            ylab="CTE SCL", xlim=c(0, 1), ylim=c(0, 1), las=1)
segments(x0=0, y0=0, x1=1, y1=1, lty=2, col="red")
  
}
}
\author{
Marc Girondot
}
