% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HatchingSuccess.fit.R
\name{HatchingSuccess.fit}
\alias{HatchingSuccess.fit}
\title{Fit a hatching success model to data using maximum likelihood}
\usage{
HatchingSuccess.fit(par, data, fixed.parameters = NULL,
  column.Incubation.temperature = "Incubation.temperature",
  column.Hatched = "Hatched", column.NotHatched = "NotHatched")
}
\arguments{
\item{par}{A set of parameters.}

\item{data}{A dataset in a data.frame with a least three columns: Incubation.temperature, Hatched and NotHatched}

\item{fixed.parameters}{A set of parameters that must not be fitted.}

\item{column.Incubation.temperature}{Name of the column with incubation temperatures}

\item{column.Hatched}{Name of the column with hatched number}

\item{column.NotHatched}{Name of the column with not hatched number}
}
\value{
Return a object of class HatchingSuccess
}
\description{
Set of functions to study the hatching success.\cr
}
\details{
HatchingSuccess.fit fits a hatching success model to data
}
\examples{
\dontrun{
library(embryogrowth)
totalIncubation_Cc <- subset(DatabaseTSD, 
                             Species=="Caretta caretta" & 
                               Note != "Sinusoidal pattern" & 
                               !is.na(Total) & Total != 0)

par <- c(S.low=0.5, S.high=0.3, 
         P.low=25, deltaP=10, MaxHS=logit(0.8))
         
HatchingSuccess.lnL(par=par, data=totalIncubation_Cc)

g <- HatchingSuccess.fit(par=par, data=totalIncubation_Cc)

HatchingSuccess.lnL(par=g$par, data=totalIncubation_Cc)

par(mar=c(4, 4, 1, 1), +0.4)
plot(g)
}
}
\seealso{
Other Hatching success: \code{\link{HatchingSuccess.MHmcmc_p}},
  \code{\link{HatchingSuccess.MHmcmc}},
  \code{\link{HatchingSuccess.lnL}},
  \code{\link{HatchingSuccess.model}},
  \code{\link{logLik.HatchingSuccess}},
  \code{\link{nobs.HatchingSuccess}},
  \code{\link{plot.HatchingSuccess}},
  \code{\link{predict.HatchingSuccess}}
}
\author{
Marc Girondot
}
\concept{Hatching success}
