% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_param_errors.R
\name{make_param_errors}
\alias{make_param_errors}
\title{Calculate parameter errors via inversion of the Hessian matrix (either pracma or numeric approximations).}
\usage{
make_param_errors(params, x, y, weight, family = poisson(),
  method = "numeric", dispersion = 1)
}
\arguments{
\item{params}{Optimal parameters}

\item{x}{An \emph{n}-by-\emph{p} design matrix.}

\item{y}{A vector of observation of length \emph{n}.}

\item{weight}{A \emph{n} length vector of observation weight terms.  This is currently designed to be either the exposure for a Poisson model or the number of trials for a Logistic model.}

\item{family}{GLM family to fit.}

\item{method}{Control string.  Set to 'numeric' or 'pracma'.}

\item{dispersion}{Model dispersion parameter for over/ under-dispersed models.  Defaults to 1.}
}
\value{
Calculate the errors associated with each set of parameters.
}
\description{
Calculate parameter errors via inversion of the Hessian matrix (either pracma or numeric approximations).
}
\examples{
x <- model.matrix(~ factor(wool) + factor(tension), warpbreaks)
y <- warpbreaks$breaks

m <- em.glm(x = x, y = y, K = 2, b.init = "random")
make_param_errors(m$params, x = x, y = y ,weight = c(1))

}
