% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-ollama.R
\name{chat_ollama}
\alias{chat_ollama}
\alias{models_ollama}
\title{Chat with a local Ollama model}
\usage{
chat_ollama(
  system_prompt = NULL,
  base_url = Sys.getenv("OLLAMA_BASE_URL", "http://localhost:11434"),
  model,
  seed = NULL,
  api_args = list(),
  echo = NULL,
  api_key = NULL,
  api_headers = character()
)

models_ollama(base_url = "http://localhost:11434")
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{base_url}{The base URL to the endpoint; the default uses OpenAI.}

\item{model}{The model to use for the chat.
Use \code{models_ollama()} to see all options.}

\item{seed}{Optional integer seed that ChatGPT uses to try and make output
more reproducible.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{output}: echo text and tool-calling output as it streams in (default
when running at the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}

\item{api_key}{Ollama doesn't require an API key for local usage and in most
cases you do not need to provide an \code{api_key}.

However, if you're accessing an Ollama instance hosted behind a reverse
proxy or secured endpoint that enforces bearer‐token authentication, you
can set \code{api_key} (or the \code{OLLAMA_API_KEY} environment variable).}

\item{api_headers}{Named character vector of arbitrary extra headers appended
to every chat API call.}
}
\value{
A \link{Chat} object.
}
\description{
To use \code{chat_ollama()} first download and install
\href{https://ollama.com}{Ollama}. Then install some models either from the
command line (e.g. with \verb{ollama pull llama3.1}) or within R using
{\href{https://hauselin.github.io/ollama-r/}{ollamar}} (e.g.
\code{ollamar::pull("llama3.1")}).

This function is a lightweight wrapper around \code{\link[=chat_openai]{chat_openai()}} with
the defaults tweaked for ollama.
\subsection{Known limitations}{
\itemize{
\item Tool calling is not supported with streaming (i.e. when \code{echo} is
\code{"text"} or \code{"all"})
\item Models can only use 2048 input tokens, and there's no way
to get them to use more, except by creating a custom model with a
different default.
\item Tool calling generally seems quite weak, at least with the models I have
tried it with.
}
}
}
\examples{
\dontrun{
chat <- chat_ollama(model = "llama3.2")
chat$chat("Tell me three jokes about statisticians")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_anthropic}()},
\code{\link{chat_aws_bedrock}()},
\code{\link{chat_azure_openai}()},
\code{\link{chat_cloudflare}()},
\code{\link{chat_databricks}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_github}()},
\code{\link{chat_google_gemini}()},
\code{\link{chat_groq}()},
\code{\link{chat_huggingface}()},
\code{\link{chat_mistral}()},
\code{\link{chat_openai}()},
\code{\link{chat_openrouter}()},
\code{\link{chat_perplexity}()},
\code{\link{chat_portkey}()}
}
\concept{chatbots}
