% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-cloudflare.R
\name{chat_cloudflare}
\alias{chat_cloudflare}
\title{Chat with a model hosted on CloudFlare}
\usage{
chat_cloudflare(
  account = cloudflare_account(),
  system_prompt = NULL,
  params = NULL,
  api_key = cloudflare_key(),
  model = NULL,
  api_args = list(),
  echo = NULL
)
}
\arguments{
\item{account}{The Cloudflare account ID. Taken from the
\code{CLOUDFLARE_ACCOUNT_ID} env var, if defined.}

\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{params}{Common model parameters, usually created by \code{\link[=params]{params()}}.}

\item{api_key}{The API key to use for authentication. You generally should
not supply this directly, but instead set the \code{HUGGINGFACE_API_KEY} environment
variable.}

\item{model}{The model to use for the chat (defaults to "meta-llama/Llama-3.3-70b-instruct-fp8-fast").
We regularly update the default, so we strongly recommend explicitly specifying a model for anything other than casual use.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{output}: echo text and tool-calling output as it streams in (default
when running at the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
\href{https://www.cloudflare.com/developer-platform/products/workers-ai/}{Cloudflare}
works AI hosts a variety of open-source AI models. To use the Cloudflare
API, you must have an Account ID and an Access Token, which you can obtain
\href{https://developers.cloudflare.com/workers-ai/get-started/rest-api/}{by following these instructions}.
\subsection{Known limitations}{
\itemize{
\item Tool calling does not appear to work.
\item Images don't appear to work.
}
}
}
\examples{
\dontrun{
chat <- chat_cloudflare()
chat$chat("Tell me three jokes about statisticians")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_anthropic}()},
\code{\link{chat_aws_bedrock}()},
\code{\link{chat_azure_openai}()},
\code{\link{chat_cortex_analyst}()},
\code{\link{chat_databricks}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_github}()},
\code{\link{chat_google_gemini}()},
\code{\link{chat_groq}()},
\code{\link{chat_huggingface}()},
\code{\link{chat_mistral}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_openrouter}()},
\code{\link{chat_perplexity}()},
\code{\link{chat_portkey}()}
}
\concept{chatbots}
