% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate.R
\name{translate}
\alias{translate}
\title{Translate an R expression}
\usage{
translate(expr, rules, env = parent.frame())
}
\arguments{
\item{expr}{\link[=elixir-expression]{Expression} or list of
\link[=elixir-expression]{expressions} to be translated.}

\item{rules}{Which \link[=elixir-rules]{rules} to follow. You can pass a string
from among \code{"C"}, \code{"C++"}, \code{"Lua"}, or \code{"R"}, or a list with translation
rules (see Details).}

\item{env}{Environment for injections in \code{expr} (see
\link[=elixir-expression]{expression}).}
}
\value{
The translated expression as a single character string.
}
\description{
Takes an R expression (in the sense of \code{\link[rlang:is_expression]{rlang::is_expression()}}) and
translates it into a character string giving the equivalent expression in
another programming language, according to the supplied
\link[=elixir-rules]{rules}.

This function is experimental.
}
\details{
The parameter \code{rules} can be a character string naming a "built-in"
\link[=elixir-rules]{ruleset}. Otherwise, \code{rules} should be a list with the
following elements:
\itemize{
\item \code{ops}: an unnamed list of operator definitions, each of which should be a
list with four elements:
\itemize{
\item \code{arity} the number of operands
\item \code{prec} the precedence of the operator (lower numbers equal higher
precedence)
\item \code{assoc} the associativity of the operator, either \code{"LTR"}, \code{"RTL"}, or
anything else for no associativity
\item \code{str} a \code{\link[glue:glue]{glue::glue()}} format string with \code{{A[1]}}, \code{{A[2]}}, etc.,
standing in for the first, second, etc. operands.
\item \code{nopar} a numeric vector with indices of arguments to the operator which
should never be enclosed in parentheses. The default and usual value is
integer(0), but (for example) it can be 2 for the \code{[} operator, as
parentheses within the second argument (the content of the brackets)
are redundant.
}

The function \code{elixir:::op} can help to assemble such lists.
\item \code{paren} a \code{\link[glue:glue]{glue::glue()}} format string with \code{{x}} standing in for the
enclosed expression. Describes how parentheses are expressed in the
target language. Example: \code{"({x})"} is correct for virtually all
programming languages.
\item \code{symbol}: a function which takes a symbol and returns a character string,
representing the name of that symbol in the target language. This
could just be equal to \link[base:character]{base::as.character}, but it can be changed to
something else in case you want name mangling, or e.g. some processing
to replace \code{.} in symbols with some other character (as \code{.} are often
not allowed as part of symbols in popular languages).
\item \code{literal}: a named list in which the name refers to the class of the
operand to translate, and the value should be a function of a single
argument (the operand) returning a character string.
}

It may be helpful to inspect \code{elixir:::ruleset} to clarify the above
format.

There are some important shortcomings to \code{\link[=translate]{translate()}}. Here are some
potential pitfalls:
\itemize{
\item Named arguments are not supported, because we cannot translate an R
function call like \code{mean(x, na.rm = TRUE)} without knowing which
parameter of \code{mean} matches to \code{na.rm}.
\item Division: An R expression like \code{1/3} gets translated into \code{1./3.} in
C/C++, as numeric literals are coerced to type \code{double}. So both of these
evaluate to 0.333. However, the R expression \code{1L/3L} will get translated
into \code{1/3} in C/C++, which evaluates to 0 (as it is integer division).
\item Modulo: R uses "Knuth's modulo", where \code{a \%\% b} has the same sign as \code{b}.
Lua also uses Knuth's modulo, but C/C++ use "truncated modulo", where
\verb{a \% b} has the same sign as \code{a}. (see
\href{https://en.wikipedia.org/wiki/Modulo#Variants_of_the_definition}{Wikipedia}
for details). So when converting a modulo expression from R to C/C++, a
call to the function \code{kmod} is generated in the C/C++ expression. This is
not a standard library function, so you will have to provide a definition
yourself. A workable definition is:
\verb{double kmod(double x, double y) \{ double r = fmod(x, y); return r && r < 0 != y < 0 ? r + y : r; \}}
(R) or \verb{a \% b} (Lua)
\item Types: In R, the type of \code{a \%\% b} and of \code{a \%/\% b} depends on the type of
\code{a} and \code{b} (if both are integers, the result is an integer; if at least
one is numeric, the result is numeric).
\item Chained assignment does not work in Lua.
}
}
\examples{
translate({x ^ y}, "C++")
}
