\name{elec-package}
\alias{elec-package}
\alias{elec}
\docType{package}
\title{
Statistical Election Audits Package
}
\description{
 This is a collection of functions written to do various sorts
 of statistical election audits.  There are also functions to generate
 simulated voting data, and simulated ``truth'' so as to do simulations
 to check charactaristics of these methods.  The package includes two
 data sets consisting of actual reported voting results for races held
 November, 2008, in California.
 It also includes actual audit date for one of these races.
 
}

\details{
\tabular{ll}{
Package: \tab elec\cr
Type: \tab Package\cr
Version: \tab 0.1\cr
Date: \tab 2009-01-14\cr
License: \tab GPL (>= 2)\cr
LazyLoad: \tab yes\cr
}

There are three general audit styles implemented in this package.  For
each style there are two main computational tasks provided: estimate
the needed sample size and expected workload, and calculate $P$-values
for a given audit result.  The three methods are CAST (see
\code{\link{CAST.calc.sample}} and \code{\link{CAST}}), the
Trinomial Bound (see
\code{\link{tri.calc.sample}} or \code{\link{trinomial.bound}}) , and
Kaplan-Markov (KM) Bound (see \code{\link{KM.calc.sample}} and \code{\link{KM.audit}}).

The examples primarily use a data set included in the package,
\code{\link{santa.cruz}} and \code{\link{santa.cruz.audit}}, which holds the ballot counts for a Santa
Cruz, CA race that we audited using these methods.  See
\code{\link{trinomial.bound}} for how these data were analyzed.  The
\code{\link{yolo}} data set
holds precinct level counts for a race in Yolo county. 

There are also
many functions allowing for construction of new audit methods and
simulations.  This includes methods that generate fake race data that
can be used for computational simulations to assess the efficay of different
auditing approaches (see, e.g., \code{\link{make.sample}} and \code{\link{make.truth}}).

The package grew out of an earlier, disorganized package that implemented general routines for election auditing.  Pieces
of this package are used by the aforementioned cleaner methods, but all
the individual functions are still there for specific uses, such as
making different tests.  Start with \link{stark.test}, which has an
index of these pieces in its ``see also'' section.

If you find yourself confused, please contact the maintainer,
L. Miratrix, for help.  This will help improve the clarity of the
package a great deal.

}
\author{
  Luke W. Miratrix
  
  Maintainer: Luke W. Miratrix <luke@vzvz.org>

}
\references{
  CAST and KM were developed by Philip B. Stark.  The Trinomial bound was
  developed by Luke W. Miratrix and Philip B. Stark.
  
  For general papers on election auditing see the list at
  http://www.stat.berkeley.edu/~stark/Vote/index.htm.
  
  In particular, for the trinomial bound, see Luke W. Miratrix and Philip B. Stark. (2009) Election Audits
  using a Trinomial Bound (in press).
  
  For the KM bound see Stark, P.B., 2009. Risk-limiting post-election
  audits: P-values from common probability inequalities.
  
  For an overview of the races and the methods, see 
Joseph Lorenzo Hall1, Philip B. Stark, Luke W. Miratrix, Elaine Ginnold, Freddie 
Oakley, Tom Stanionis, and Gail Pellerin. (2009) Implementing
Risk-Limiting Audits in California (in press).
}

\keyword{ package }

