% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/termvectors.R
\name{termvectors}
\alias{termvectors}
\title{Termvectors}
\usage{
termvectors(
  conn,
  index,
  type = NULL,
  id = NULL,
  body = list(),
  pretty = TRUE,
  field_statistics = TRUE,
  fields = NULL,
  offsets = TRUE,
  parent = NULL,
  payloads = TRUE,
  positions = TRUE,
  realtime = TRUE,
  preference = "random",
  routing = NULL,
  term_statistics = FALSE,
  version = NULL,
  version_type = NULL,
  ...
)
}
\arguments{
\item{conn}{an Elasticsearch connection object, see \code{\link[=connect]{connect()}}}

\item{index}{(character) The index in which the document resides.}

\item{type}{(character) The type of the document. optional}

\item{id}{(character) The id of the document, when not specified a doc
param should be supplied.}

\item{body}{(character) Define parameters and or supply a document to get
termvectors for}

\item{pretty}{(logical) pretty print. Default: \code{TRUE}}

\item{field_statistics}{(character) Specifies if document count, sum
of document frequencies and sum of total term frequencies should be
returned. Default: \code{TRUE}}

\item{fields}{(character) A comma-separated list of fields to return.}

\item{offsets}{(character) Specifies if term offsets should be returned.
Default: \code{TRUE}}

\item{parent}{(character) Parent id of documents.}

\item{payloads}{(character) Specifies if term payloads should be returned.
Default: \code{TRUE}}

\item{positions}{(character) Specifies if term positions should be returned.
Default: \code{TRUE}}

\item{realtime}{(character) Specifies if request is real-time as opposed to
near-real-time (Default: \code{TRUE}).}

\item{preference}{(character) Specify the node or shard the operation
should be performed on (Default: \code{random}).}

\item{routing}{(character) Specific routing value.}

\item{term_statistics}{(character) Specifies if total term frequency and
document frequency should be returned. Default: \code{FALSE}}

\item{version}{(character) Explicit version number for concurrency control}

\item{version_type}{(character) Specific version type, valid choices are:
'internal', 'external', 'external_gte', 'force'}

\item{...}{Curl args passed on to \link[crul:verb-POST]{crul::verb-POST}}
}
\description{
Termvectors
}
\details{
Returns information and statistics on terms in the fields of a
particular document. The document could be stored in the index or
artificially provided by the user (Added in 1.4). Note that for
documents stored in the index, this is a near realtime API as the term
vectors are not available until the next refresh.
}
\examples{
\dontrun{
x <- connect()

if (!index_exists(x, 'plos')) {
  plosdat <- system.file("examples", "plos_data.json",
    package = "elastic")
  plosdat <- type_remover(plosdat)
  invisible(docs_bulk(x, plosdat))
}
if (!index_exists(x, 'omdb')) {
  omdb <- system.file("examples", "omdb.json", package = "elastic")
  omdb <- type_remover(omdb)
  invisible(docs_bulk(x, omdb))
}

body <- '{
  "fields" : ["title"],
  "offsets" : true,
  "positions" : true,
  "term_statistics" : true,
  "field_statistics" : true
}'
termvectors(x, 'plos', id = 29, body = body)

body <- '{
  "fields" : ["Plot"],
  "offsets" : true,
  "positions" : true,
  "term_statistics" : true,
  "field_statistics" : true
}'
termvectors(x, 'omdb', id = Search(x, "omdb", size=1)$hits$hits[[1]]$`_id`,
body = body)
}
}
\references{
\url{http://www.elastic.co/guide/en/elasticsearch/reference/current/docs-termvectors.html}
}
\seealso{
\code{\link[=mtermvectors]{mtermvectors()}}
}
