% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{clustInd_kmeans}
\alias{clustInd_kmeans}
\title{K-means clustering with indices}
\usage{
clustInd_kmeans(
  ind_data,
  vars_combinations,
  dist_vector = c("euclidean", "mahalanobis"),
  n_cluster = 2,
  true_labels = NULL,
  n_cores = 1
)
}
\arguments{
\item{ind_data}{Dataframe containing indices applied to the original data and
its first and second derivatives. See \link{generate_indices}.}

\item{vars_combinations}{\code{list} containing one or more combinations of indices in
\code{ind_data}. If it is non-named, the names of the variables are set to
vars1, ..., varsk, where k is the number of elements in \code{vars_combinations}.}

\item{dist_vector}{Atomic vector of distance metrics. The possible values are,
"euclidean", "mahalanobis" or both.}

\item{n_cluster}{Number of clusters to create.}

\item{true_labels}{Vector of true labels for validation.
(if it is not known true_labels is set to NULL)}

\item{n_cores}{Number of cores to do parallel computation. 1 by default,
which mean no parallel execution.}
}
\value{
A list containing hierarchical clustering results
for each configuration

A list containing kmeans clustering results for each configuration
}
\description{
Perform k-means clustering for a different combinations of indices and
distances.
}
\examples{
vars1 <- c("dtaEI", "dtaMEI")
vars2 <- c("dtaHI", "dtaMHI")
data <- ehymet::sim_model_ex1()
data_ind <- generate_indices(data)
clustInd_kmeans(data_ind, list(vars1, vars2))

}
