% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{clustInd_hierarch}
\alias{clustInd_hierarch}
\title{Perform hierarchical clustering for a different combinations of indices,
method and distance}
\usage{
clustInd_hierarch(
  ind_data,
  vars_combinations,
  method_list = c("single", "complete", "average", "centroid", "ward.D2"),
  dist_vector = c("euclidean", "manhattan"),
  n_cluster = 2,
  true_labels = NULL,
  n_cores = 1
)
}
\arguments{
\item{ind_data}{Dataframe containing indices applied to the original data and
its first and second derivatives. See \link{generate_indices}.}

\item{vars_combinations}{\code{list} containing one or more combinations of indices in
\code{ind_data}. If it is non-named, the names of the variables are set to
vars1, ..., varsk, where k is the number of elements in \code{vars_combinations}.}

\item{method_list}{\code{list} of clustering methods.}

\item{dist_vector}{\code{list} of distance metrics.}

\item{n_cluster}{number of clusters to generate.}

\item{true_labels}{Vector of true labels for validation
(if it is not known true_labels is set to NULL)}

\item{n_cores}{Number of cores to do parallel computation. 1 by default,
which mean no parallel execution.}
}
\value{
A \code{list} containing hierarchical clustering results
for each configuration.
}
\description{
Perform hierarchical clustering for a different combinations of indices,
method and distance
}
\examples{
vars1 <- c("dtaEI", "dtaMEI")
vars2 <- c("dtaHI", "dtaMHI")
data <- ehymet::sim_model_ex1()
data_ind <- generate_indices(data)
clustInd_hierarch(data_ind, list(vars1, vars2))

}
