% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_ef_file.R
\name{read_ef_file}
\alias{read_ef_file}
\title{Load a CSV file from the European Flux Database}
\usage{
read_ef_file(file_name)
}
\arguments{
\item{file_name}{Full path to 1 fluxes file}
}
\value{
a data frame as loaded from the file, added with 'efreadr_year', 'efreadr_file_name' and 'efreadr_site_id' columns, and 'efreadr_date' column for half-hourly fluxes
}
\description{
File name is parsed to extract year, site identification and aggregation type.
The file name must point to a valid European Fluxes file, in CSV format and must
resolve to a valid file format name.
}
\details{
Year, file name and site identification are added as fields in the returned data frame
as 'efreadr_year', 'efreader_file_name' and 'efreader_site_id'.
}
\note{
For semi-hourly L4 aggregation (i.e. "h" aggregation in file name) the last row is
reported as month 1, day 1, hour 00:00. A normal date conversion would convert this date to
be the very first half-hour in January 1st of the current year whereas it should be the first half-hour of the
January 1st of the following year.
Therefore a class date field ('efreader_date') is added to the returned data frame holding the correct
date (ie: 1st January of the following year).
}
\examples{
file_name <- system.file("extdata", "CEIP_EC_L4_d_FABar_2015_v02.txt", package = "efreadr")
read_ef_file(file_name)
}

