% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_utils.R
\name{eem_sample_names<-}
\alias{eem_sample_names<-}
\title{Set the sample names of an eem or eemlist objects}
\usage{
eem_sample_names(x) <- value
}
\arguments{
\item{x}{An object of class \code{eem} or \code{eemlist}.}

\item{value}{A character vector with new sample names. Must be equal
in length to the number of samples in the \code{eem} or \code{eemlist}.}
}
\value{
An \code{eem} or \code{eemlist}.
}
\description{
Set the sample names of an eem or eemlist objects
}
\examples{
folder <- system.file("extdata/cary/eem", package = "eemR")
eems <- eem_read(folder)

eem_sample_names(eems)
eem_sample_names(eems) <- c("a", "b", "c")
eem_sample_names(eems)

}

