% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_neighbor.R
\name{sd_neighbor}
\alias{sd_neighbor}
\title{A function to create a dataframe of a school district and all its
  neighbors}
\usage{
sd_neighbor(data_year = "2019", school_district = NULL, table_vars =
  c('Name', 'Enrollment', 'Poverty Rate', 'Percent Nonwhite', 'Local Revenue PP',
   'State Revenue PP', 'Type'))
}
\arguments{
\item{data_year}{Four digit year of master data to pull in. Options include
2013- 2019. Defaults to 2019.}

\item{school_district}{Seven digit NCESID of the school district. Default is
NULL. To find the NCESID for any school district, use
\code{\link{masterpull}} to search for your district.}

\item{table_vars}{Variable or list of variables to include in the table. Use
tables_vars = “options” to print a list of the variables. Defaults to:
Name; Enrollment; Poverty Rate; Percent Nonwhite; Local Revenue, per Pupil;
State Revenue, per Pupil; Type}
}
\value{
A dataframe where each observation is a school district.
}
\description{
This function allows you to create a table to view any school
  district and its neighbors with selected data from EdBuild's master
  datafile.
}
\examples{
\donttest{table <- sd_neighbor(
         data_year = "2019",
         school_district = "0622710",
         table_vars = c("Name",
                       "Percent Nonwhite",
                       "Median Household Income",
                        "State Revenue PP")
       )}
}
\seealso{
\code{\link{sd_neighbor_xlsx}}, \code{\link{sd_table_xlsx}},
  \code{\link{master_codebook}}, \code{\link{masterpull}}
  \code{\link{neigh_diff}}
}
\keyword{EdBuild}
\keyword{difference}
\keyword{neighbors}
\keyword{table}
