% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectoryPlots.R
\encoding{UTF-8}
\name{trajectoryPlot}
\alias{trajectoryPlot}
\alias{trajectoryPCoA}
\title{Trajectory plots}
\usage{
trajectoryPCoA(
  x,
  traj.colors = NULL,
  axes = c(1, 2),
  survey.labels = FALSE,
  time.labels = FALSE,
  ...
)

trajectoryPlot(
  coords,
  sites,
  surveys = NULL,
  times = NULL,
  traj.colors = NULL,
  axes = c(1, 2),
  survey.labels = FALSE,
  time.labels = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{trajectories}}.}

\item{traj.colors}{A vector of colors (one per site). If \code{selection != NULL} the length of the color vector should be equal to the number of sites selected.}

\item{axes}{The pair of principal coordinates to be plotted.}

\item{survey.labels}{A boolean flag to indicate whether surveys should be added as text next to arrow endpoints}

\item{time.labels}{A boolean flag to indicate whether times should be added as text next to arrow endpoints}

\item{...}{Additional parameters for function \code{\link{arrows}}.}

\item{coords}{A data.frame or matrix where rows are ecosystem states and columns are coordinates in an arbitrary space}

\item{sites}{A vector indicating the site corresponding to each ecosystem state.}

\item{surveys}{A vector indicating the survey corresponding to each ecosystem state (only necessary when surveys are not in order).}

\item{times}{A numeric vector indicating survey times.}
}
\value{
Function \code{trajectoryPCoA} returns the result of calling \code{\link{cmdscale}}.
}
\description{
Set of plotting functions for Ecological Trajectory Analysis:
}
\details{
\itemize{
\item{Function \code{trajectoryPCoA} performs principal coordinates analysis (\code{\link{cmdscale}}) and draws trajectories in the ordination scatterplot.}
\item{Function \code{trajectoryPlot} draws trajectories in a scatter plot corresponding to the input coordinates.}
}
}
\examples{
#Description of sites and surveys
sites <- c("1","1","1","2","2","2")
surveys <- c(1,2,3,1,2,3)
  
#Raw data table
xy<-matrix(0, nrow=6, ncol=2)
xy[2,2]<-1
xy[3,2]<-2
xy[4:6,1] <- 0.5
xy[4:6,2] <- xy[1:3,2]
xy[6,1]<-1

#Define trajectory data
x <- defineTrajectories(dist(xy), sites, surveys)
  
#Draw trajectories using original coordinates
trajectoryPlot(xy, sites, surveys, 
               traj.colors = c("black","red"), lwd = 2)

#Draw trajectories in a PCoA
trajectoryPCoA(x, 
               traj.colors = c("black","red"), lwd = 2)   
  
#Should give the same results if surveys are not in order 
#(here we switch surveys for site 2)
temp <- xy[5,]
xy[5,] <- xy[6,]
xy[6,] <- temp
surveys[5] <- 3
surveys[6] <- 2
  
trajectoryPlot(xy, sites, surveys, 
               traj.colors = c("black","red"), lwd = 2)   
 
x <- defineTrajectories(dist(xy), sites, surveys)
trajectoryPCoA(x, 
               traj.colors = c("black","red"), lwd = 2)   
}
\references{
De \enc{Cáceres}{Caceres} M, Coll L, Legendre P, Allen RB, Wiser SK, Fortin MJ, Condit R & Hubbell S. (2019). Trajectory analysis in community ecology. Ecological Monographs 89, e01350.
}
\seealso{
\code{\link{trajectoryMetrics}}, \code{\link{transformTrajectories}}, \code{\link{cmdscale}}, \code{\link{cyclePCoA}}
}
\author{
Miquel De \enc{Cáceres}{Caceres}, CREAF

Anthony Sturbois, Vivarmor nature, Réserve Naturelle nationale de la Baie de Saint-Brieuc
}
