% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projections.R
\name{projections}
\alias{projections}
\title{Projections of a Country-Product Network}
\usage{
projections(
  proximity_country,
  proximity_product,
  avg_links = 5,
  tolerance = 0.05,
  compute = "both"
)
}
\arguments{
\item{proximity_country}{(Type: dgCMatrix) the output from
\code{proximity()}) or an equivalent arrangement.}

\item{proximity_product}{(Type: dgCMatrix) the output from
\code{proximity()}) or an equivalent arrangement.}

\item{avg_links}{average number of connections for the projections.
By default this is set to \code{5}.}

\item{tolerance}{tolerance for proximity variation on each iteration until
obtaining the desired average number of connections.
By default this is set to \code{0.05}.}

\item{compute}{(Type: character) the proximity to compute. By default this is
\code{"both"} (both projections) but it can also be \code{"country"}
or \code{"product"}.}
}
\value{
A list of two graphs.
}
\description{
\code{projections()} computes two graphs that are particularly
useful to visualize product-product and country-country similarity.
}
\details{
The current implementation follows
\insertCite{atlas2014}{economiccomplexity} to create simplified graphs
that correspond to a simplification of the proximity matrices. The result is
obtained by iterating and reducing links until the desired average number of
links per node is obtained, or a spaning tree after the strongest links is
returned when is not possible to return the desired network.
}
\examples{
net <- projections(
  economiccomplexity_output$proximity$proximity_country,
  economiccomplexity_output$proximity$proximity_product,
  avg_links = 10,
  tolerance = 0.1
)

# partial view of projections
igraph::E(net$network_country)[1:5]
igraph::E(net$network_product)[1:5]

}
\references{
For more information see:

\insertRef{atlas2014}{economiccomplexity}

and the references therein.
}
\keyword{functions}
