% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexity_outlook.R
\name{complexity_outlook}
\alias{complexity_outlook}
\title{Complexity Outlook}
\usage{
complexity_outlook(balassa_index, proximity_product, complexity_index_product)
}
\arguments{
\item{balassa_index}{(Type: dgCMatrix) the output from
\code{balassa_index()}) or an equivalent arrangement.}

\item{proximity_product}{(Type: dgCMatrix) the output from
\code{proximity()}) or an equivalent arrangement.}

\item{complexity_index_product}{(Type: numeric) the output from
\code{complexity_measures()}) or an equivalent arrangement.}
}
\value{
A list of two named numeric vectors.
}
\description{
\code{complexity_outlook()} computes the Complexity Outlook
Index and the Complexity Outlook Gain.
}
\details{
The current implementation follows
\insertCite{atlas2014}{economiccomplexity} to measure unexploited
export oppportunities.
}
\examples{
co <- complexity_outlook(
 economiccomplexity_output$balassa_index,
 economiccomplexity_output$proximity$proximity_product,
 economiccomplexity_output$complexity_measures$complexity_index_product
)

# partial view of complexity outlook
co$complexity_outlook_index[1:5]
co$complexity_outlook_gain[1:5,1:5]

}
\references{
For more information on this index see:

\insertRef{atlas2014}{economiccomplexity}

and the references therein.
}
\keyword{functions}
