% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ee_utils.R
\name{ee_paginator}
\alias{ee_paginator}
\title{ecoengine paginator}
\usage{
ee_paginator(page, total_obs, page_size = 1000)
}
\arguments{
\item{page}{requested page number or page range. Can also be "all"}

\item{total_obs}{Total number of records available for any search query}

\item{page_size}{Default is \code{25}. Set higher if needed.}
}
\description{
Takes a page range and total number of observations to return the right sequence of pages that need to be crawled.
}
\examples{
\dontrun{
ee_paginator(1, 100)
ee_paginator("all", 100)
ee_paginator(1:2, 1000)
ee_paginator(1:4, 3800)
# This will return an error since there are only 4 pages per 100 observations
ee_paginator(1:5, 10000)
}
}

