% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_data.R
\name{save_data}
\alias{save_data}
\title{Save an ecocomDP dataset}
\usage{
save_data(dataset, path, type = ".rds", name = NULL)
}
\arguments{
\item{dataset}{(list) One or more datasets of the structure returned by \code{read_data()}. Name of the \code{dataset} object will become the file name if \code{name} is not used.}

\item{path}{(character) Path to the directory in which \code{dataset} will be written.}

\item{type}{(character) Type of file to save the \code{dataset} as. Default is ".rds" but can also be ".csv". Note: metadata and validation_issues are lost when using ".csv".}

\item{name}{(character) An optional argument for setting the saved file name (for .rds) if you'd like it to be different than \code{dataset}'s object name.}
}
\value{
\item{.rds}{If \code{type = ".rds"}, then an .rds representation of \code{dataset} is returned.}
    \item{.csv}{If \code{type = ".csv"}, then an set of .csv files are written to a sub-directory of \code{path} named after the data package/product ID.}
}
\description{
Save an ecocomDP dataset
}
\note{
Subsequent calls won't overwrite files or directories
}
\examples{
# Create a list of datasets
datasets <- c(ants_L1, ants_L1, ants_L1)  # 3 of the same, with different names
names(datasets) <- c("ds1", "ds2", "ds3")

# Create directory for the data
mypath <- paste0(tempdir(), "/data")
dir.create(mypath)

# Save as .rds
save_data(datasets, mypath)
dir(mypath)

# Save as .rds with the name "mydata"
save_data(datasets, mypath, name = "mydata")
dir(mypath)

# Save as .csv
save_data(datasets, mypath, type = ".csv")
dir(mypath)

# Clean up
unlink(mypath, recursive = TRUE)

}
