print.summary.eco <- function(x, digits=max(3, getOption("digits")-3), ...) {
	cat("\nCall: ") 
  	cat(paste(deparse(x$call), sep="\n", collapse="\n"))

        cat("\n")
	if (!is.null(x$param.table)) {
           cat("\nParameter Estimates:\n")
           printCoefmat(x$param.table, digits=digits, na.print="NA",...)
        }
 
        cat("\nAggregate Estimates:\n")
        printCoefmat(x$agg.table, digits=digits, na.print="NA",...)

        cat("\nNumber of Units:", x$n.obs)
        cat("\nNumber of Monte Carlo Draws:", x$n.draws)
   
  
        if (!is.null(x$W1.table)) {
           cat("\n\nUnit-level Estimates of W1:\n")
           printCoefmat(x$W1.table, digits=digits, na.print="NA",...)
           cat("\n\nUnit-level Estimates of W2:\n")
           printCoefmat(x$W2.table, digits=digits, na.print="NA",...)
        }

      cat("\n")
      invisible(x)
}
