% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_functions.R
\name{s_modules}
\alias{s_modules}
\title{Simulate Covariates With Exposure Dependent Correlations}
\usage{
s_modules(n, p, rho, exposed, ...)
}
\arguments{
\item{n}{number of observations}

\item{p}{total number of predictors to simulate}

\item{rho}{numeric value representing the expected correlation between green
module and red module}

\item{exposed}{binary numeric vector of length \code{n} with 0 for unexposed
and 1 for exposed}

\item{...}{arguments passed to the \code{\link[WGCNA]{simulateDatExpr}} function}
}
\value{
\code{n x p} matrix of simulated data
}
\description{
This is a wrapper of the \code{\link[WGCNA]{simulateDatExpr}}
  function which simulates data in a modular structure (i.e. in blocks). This
  function simulates data in 5 blocks referred to as Turquoise, Blue, Red,
  Green and Yellow, separately for exposed (E=1) and unexposed (E=0)
  observations.
}
\examples{
library(magrittr)
p <- 1000
n <- 200
d0 <- s_modules(n = 100, p = 1000, rho = 0, exposed = FALSE,
                modProportions = c(0.15,0.15,0.15,0.15,0.15,0.25),
                minCor = 0.01,
                maxCor = 1,
                corPower = 1,
                propNegativeCor = 0.3,
                backgroundNoise = 0.5,
                signed = FALSE,
                leaveOut = 1:4)

d1 <- s_modules(n = 100, p = 1000, rho = 0.90, exposed = TRUE,
                modProportions = c(0.15,0.15,0.15,0.15,0.15,0.25),
                minCor = 0.4,
                maxCor = 1,
                corPower = 0.3,
                propNegativeCor = 0.3,
                backgroundNoise = 0.5,
                signed = FALSE)

X <- rbind(d0$datExpr, d1$datExpr) \%>\%
 magrittr::set_colnames(paste0("Gene", 1:p)) \%>\%
 magrittr::set_rownames(paste0("Subject",1:n))
dim(X)
}

