% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdw.R
\name{echoSDWGetSystems}
\alias{echoSDWGetSystems}
\title{Downloads public water system information}
\usage{
echoSDWGetSystems(verbose = FALSE, ...)
}
\arguments{
\item{verbose}{Logical, indicating whether to provide processing and retrieval messages. Defaults to FALSE}

\item{...}{Further arguments passed as query parameters in request sent to EPA ECHO's API. For more options see: \url{https://echo.epa.gov/tools/web-services/facility-search-drinking-water#!/Safe_Drinking_Water/get_sdw_rest_services_get_systems} for a complete list of parameter options. Examples provided below.}
}
\value{
returns a dataframe
}
\description{
Returns a dataframe of permitted public water systems returned by the query.
Uses EPA's ECHO API: \url{https://echo.epa.gov/tools/web-services/facility-search-drinking-water#!/Safe_Drinking_Water/get_sdw_rest_services_get_systems}.
}
\examples{
\donttest{
## These examples require an internet connection to run
echoSDWGetSystems(p_co = "Brazos", p_st = "tx")
}
}
